/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.suggest.document.CompletionTerms;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;

class ExitableDirectoryReader
extends FilterDirectoryReader {
    ExitableDirectoryReader(DirectoryReader in, final QueryCancellation queryCancellation) throws IOException {
        super(in, new FilterDirectoryReader.SubReaderWrapper(){

            public LeafReader wrap(LeafReader reader) {
                return new ExitableLeafReader(reader, queryCancellation);
            }
        });
    }

    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) {
        throw new UnsupportedOperationException("doWrapDirectoryReader() should never be invoked");
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    static interface QueryCancellation {
        public boolean isEnabled();

        public void checkCancelled();
    }

    private static class ExitableIntersectVisitor
    implements PointValues.IntersectVisitor {
        private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 8191;
        private final PointValues.IntersectVisitor in;
        private final QueryCancellation queryCancellation;
        private int calls;

        private ExitableIntersectVisitor(PointValues.IntersectVisitor in, QueryCancellation queryCancellation) {
            this.in = in;
            this.queryCancellation = queryCancellation;
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0x1FFF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }

        public void visit(int docID) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(docID);
        }

        public void visit(int docID, byte[] packedValue) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(docID, packedValue);
        }

        public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(iterator, packedValue);
        }

        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            this.queryCancellation.checkCancelled();
            return this.in.compare(minPackedValue, maxPackedValue);
        }

        public void grow(int count) {
            this.queryCancellation.checkCancelled();
            this.in.grow(count);
        }
    }

    static class ExitablePointValues
    extends PointValues {
        private final PointValues in;
        private final QueryCancellation queryCancellation;

        private ExitablePointValues(PointValues in, QueryCancellation queryCancellation) {
            this.in = in;
            this.queryCancellation = queryCancellation;
            this.queryCancellation.checkCancelled();
        }

        public void intersect(PointValues.IntersectVisitor visitor) throws IOException {
            this.queryCancellation.checkCancelled();
            this.in.intersect((PointValues.IntersectVisitor)new ExitableIntersectVisitor(visitor, this.queryCancellation));
        }

        public long estimatePointCount(PointValues.IntersectVisitor visitor) {
            this.queryCancellation.checkCancelled();
            return this.in.estimatePointCount(visitor);
        }

        public byte[] getMinPackedValue() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getMinPackedValue();
        }

        public byte[] getMaxPackedValue() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getMaxPackedValue();
        }

        public int getNumDimensions() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getNumDimensions();
        }

        public int getNumIndexDimensions() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getNumIndexDimensions();
        }

        public int getBytesPerDimension() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getBytesPerDimension();
        }

        public long size() {
            this.queryCancellation.checkCancelled();
            return this.in.size();
        }

        public int getDocCount() {
            this.queryCancellation.checkCancelled();
            return this.in.getDocCount();
        }
    }

    private static class ExitableTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 15;
        private int calls;
        private final QueryCancellation queryCancellation;

        private ExitableTermsEnum(TermsEnum termsEnum, QueryCancellation queryCancellation) {
            super(termsEnum);
            this.queryCancellation = queryCancellation;
            this.queryCancellation.checkCancelled();
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0xF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }

        public BytesRef next() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.next();
        }
    }

    static class ExitableTerms
    extends FilterLeafReader.FilterTerms {
        private final QueryCancellation queryCancellation;

        ExitableTerms(Terms terms, QueryCancellation queryCancellation) {
            super(terms);
            this.queryCancellation = queryCancellation;
        }

        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
            return new ExitableTermsEnum(this.in.intersect(compiled, startTerm), this.queryCancellation);
        }

        public TermsEnum iterator() throws IOException {
            return new ExitableTermsEnum(this.in.iterator(), this.queryCancellation);
        }

        public BytesRef getMin() throws IOException {
            return this.in.getMin();
        }

        public BytesRef getMax() throws IOException {
            return this.in.getMax();
        }
    }

    static class ExitableLeafReader
    extends SequentialStoredFieldsLeafReader {
        private final QueryCancellation queryCancellation;

        private ExitableLeafReader(LeafReader leafReader, QueryCancellation queryCancellation) {
            super(leafReader);
            this.queryCancellation = queryCancellation;
        }

        public PointValues getPointValues(String field) throws IOException {
            PointValues pointValues = this.in.getPointValues(field);
            if (pointValues == null) {
                return null;
            }
            return this.queryCancellation.isEnabled() ? new ExitablePointValues(pointValues, this.queryCancellation) : pointValues;
        }

        public Terms terms(String field) throws IOException {
            Terms terms = this.in.terms(field);
            if (terms == null) {
                return null;
            }
            return this.queryCancellation.isEnabled() && !(terms instanceof CompletionTerms) ? new ExitableTerms(terms, this.queryCancellation) : terms;
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }

        @Override
        protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
            return reader;
        }
    }
}

