/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.DefunctConfig;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;

@DefunctConfig(value={"elasticsearch.aws.use-instance-credentials"})
public class AwsSecurityConfig {
    private String accessKey;
    private String secretKey;
    private String region;
    private String iamRole;
    private String externalId;

    @NotNull
    public Optional<String> getAccessKey() {
        return Optional.ofNullable(this.accessKey);
    }

    @Config(value="elasticsearch.aws.access-key")
    public AwsSecurityConfig setAccessKey(String key) {
        this.accessKey = key;
        return this;
    }

    @NotNull
    public Optional<String> getSecretKey() {
        return Optional.ofNullable(this.secretKey);
    }

    @Config(value="elasticsearch.aws.secret-key")
    @ConfigSecuritySensitive
    public AwsSecurityConfig setSecretKey(String key) {
        this.secretKey = key;
        return this;
    }

    public String getRegion() {
        return this.region;
    }

    @Config(value="elasticsearch.aws.region")
    public AwsSecurityConfig setRegion(String region) {
        this.region = region;
        return this;
    }

    @NotNull
    public Optional<String> getIamRole() {
        return Optional.ofNullable(this.iamRole);
    }

    @Config(value="elasticsearch.aws.iam-role")
    @ConfigDescription(value="Optional AWS IAM role to assume for authenticating. If set, this role will be used to get credentials to sign requests to ES.")
    public AwsSecurityConfig setIamRole(String iamRole) {
        this.iamRole = iamRole;
        return this;
    }

    @NotNull
    public Optional<String> getExternalId() {
        return Optional.ofNullable(this.externalId);
    }

    @Config(value="elasticsearch.aws.external-id")
    @ConfigDescription(value="Optional external id to pass to AWS STS while assuming a role")
    public AwsSecurityConfig setExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }
}

