/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.trino.plugin.elasticsearch.ElasticsearchColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.RegexpQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;

public final class ElasticsearchQueryBuilder {
    private ElasticsearchQueryBuilder() {
    }

    public static QueryBuilder buildSearchQuery(TupleDomain<ElasticsearchColumnHandle> constraint, Optional<String> query, Map<String, String> regexes) {
        BoolQueryBuilder queryBuilder = new BoolQueryBuilder();
        if (constraint.getDomains().isPresent()) {
            for (Map.Entry entry : ((Map)constraint.getDomains().get()).entrySet()) {
                ElasticsearchColumnHandle column = (ElasticsearchColumnHandle)entry.getKey();
                Domain domain = (Domain)entry.getValue();
                Preconditions.checkArgument((!domain.isNone() ? 1 : 0) != 0, (String)"Unexpected NONE domain for %s", (Object)column.name());
                if (domain.isAll()) continue;
                ElasticsearchQueryBuilder.addPredicateToQueryBuilder(queryBuilder, column.name(), domain, column.type());
            }
        }
        regexes.forEach((name, value) -> queryBuilder.filter((QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)new RegexpQueryBuilder(name, value))));
        query.map(QueryStringQueryBuilder::new).ifPresent(arg_0 -> ((BoolQueryBuilder)queryBuilder).must(arg_0));
        if (queryBuilder.hasClauses()) {
            return queryBuilder;
        }
        return new MatchAllQueryBuilder();
    }

    private static void addPredicateToQueryBuilder(BoolQueryBuilder queryBuilder, String columnName, Domain domain, Type type) {
        Preconditions.checkArgument((boolean)domain.getType().isOrderable(), (Object)"Domain type must be orderable");
        if (domain.getValues().isNone()) {
            queryBuilder.mustNot((QueryBuilder)new ExistsQueryBuilder(columnName));
            return;
        }
        if (domain.getValues().isAll()) {
            queryBuilder.filter((QueryBuilder)new ExistsQueryBuilder(columnName));
            return;
        }
        List<QueryBuilder> shouldClauses = ElasticsearchQueryBuilder.getShouldClauses(columnName, domain, type);
        if (shouldClauses.size() == 1) {
            queryBuilder.filter((QueryBuilder)Iterables.getOnlyElement(shouldClauses));
            return;
        }
        if (shouldClauses.size() > 1) {
            BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
            shouldClauses.forEach(arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).should(arg_0));
            queryBuilder.filter((QueryBuilder)boolQueryBuilder);
            return;
        }
    }

    private static List<QueryBuilder> getShouldClauses(String columnName, Domain domain, Type type) {
        ImmutableList.Builder shouldClauses = ImmutableList.builder();
        for (Range range : domain.getValues().getRanges().getOrderedRanges()) {
            Preconditions.checkState((!range.isAll() ? 1 : 0) != 0, (String)"Invalid range for column: %s", (Object)columnName);
            if (range.isSingleValue()) {
                shouldClauses.add((Object)new TermQueryBuilder(columnName, ElasticsearchQueryBuilder.getValue(type, range.getSingleValue())));
                continue;
            }
            RangeQueryBuilder rangeQueryBuilder = new RangeQueryBuilder(columnName);
            if (!range.isLowUnbounded()) {
                Object lowBound = ElasticsearchQueryBuilder.getValue(type, range.getLowBoundedValue());
                if (range.isLowInclusive()) {
                    rangeQueryBuilder.gte(lowBound);
                } else {
                    rangeQueryBuilder.gt(lowBound);
                }
            }
            if (!range.isHighUnbounded()) {
                Object highBound = ElasticsearchQueryBuilder.getValue(type, range.getHighBoundedValue());
                if (range.isHighInclusive()) {
                    rangeQueryBuilder.lte(highBound);
                } else {
                    rangeQueryBuilder.lt(highBound);
                }
            }
            shouldClauses.add((Object)rangeQueryBuilder);
        }
        if (domain.isNullAllowed()) {
            shouldClauses.add((Object)new BoolQueryBuilder().mustNot((QueryBuilder)new ExistsQueryBuilder(columnName)));
        }
        return shouldClauses.build();
    }

    private static Object getValue(Type type, Object value) {
        if (type.equals((Object)BooleanType.BOOLEAN) || type.equals((Object)TinyintType.TINYINT) || type.equals((Object)SmallintType.SMALLINT) || type.equals((Object)IntegerType.INTEGER) || type.equals((Object)BigintType.BIGINT) || type.equals((Object)DoubleType.DOUBLE)) {
            return value;
        }
        if (type.equals((Object)RealType.REAL)) {
            return Float.valueOf(Float.intBitsToFloat(Math.toIntExact((Long)value)));
        }
        if (type.equals((Object)VarcharType.VARCHAR)) {
            return ((Slice)value).toStringUtf8();
        }
        if (type.equals((Object)TimestampType.TIMESTAMP_MILLIS)) {
            return Instant.ofEpochMilli(Math.floorDiv((long)((Long)value), 1000)).atZone(ZoneOffset.UTC).toLocalDateTime().format(DateTimeFormatter.ISO_DATE_TIME);
        }
        throw new IllegalArgumentException("Unhandled type: " + String.valueOf(type));
    }
}

