/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch.client;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public record IndexMetadata(ObjectType schema) {
    public IndexMetadata {
        Objects.requireNonNull(schema, "schema is null");
    }

    public record ObjectType(List<Field> fields) implements Type
    {
        public ObjectType(List<Field> fields) {
            Objects.requireNonNull(fields, "fields is null");
            this.fields = fields = ImmutableList.copyOf(fields);
        }
    }

    public record ScaledFloatType(double scale) implements Type
    {
    }

    public record DateTimeType(List<String> formats) implements Type
    {
        public DateTimeType(List<String> formats) {
            Objects.requireNonNull(formats, "formats is null");
            this.formats = formats = ImmutableList.copyOf(formats);
        }
    }

    public record PrimitiveType(String name) implements Type
    {
        public PrimitiveType {
            Objects.requireNonNull(name, "name is null");
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="@type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=DateTimeType.class, name="date_time"), @JsonSubTypes.Type(value=ObjectType.class, name="object"), @JsonSubTypes.Type(value=PrimitiveType.class, name="primitive"), @JsonSubTypes.Type(value=ScaledFloatType.class, name="scaled_float")})
    public static interface Type {
    }

    public record Field(boolean asRawJson, boolean isArray, String name, Type type) {
        public Field {
            Preconditions.checkArgument((!asRawJson || !isArray ? 1 : 0) != 0, (String)"A column, (%s) cannot be declared as a Trino array and also be rendered as json.", (Object)name);
            Objects.requireNonNull(name, "name is null");
            Objects.requireNonNull(type, "type is null");
        }
    }
}

