/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;

public class QueryAccessRule {
    private final Set<AccessMode> allow;
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> roleRegex;
    private final Optional<Pattern> groupRegex;
    private final Optional<Pattern> queryOwnerRegex;

    @JsonCreator
    public QueryAccessRule(@JsonProperty(value="allow") Set<AccessMode> allow, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="role") Optional<Pattern> roleRegex, @JsonProperty(value="group") Optional<Pattern> groupRegex, @JsonProperty(value="queryOwner") Optional<Pattern> queryOwnerRegex) {
        this.allow = ImmutableSet.copyOf((Collection)Objects.requireNonNull(allow, "allow is null"));
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
        this.roleRegex = Objects.requireNonNull(roleRegex, "roleRegex is null");
        this.groupRegex = Objects.requireNonNull(groupRegex, "groupRegex is null");
        this.queryOwnerRegex = Objects.requireNonNull(queryOwnerRegex, "ownerRegex is null");
        Preconditions.checkState((queryOwnerRegex.isEmpty() || !allow.contains((Object)AccessMode.EXECUTE) ? 1 : 0) != 0, (Object)"A valid query rule cannot combine an queryOwner condition with access mode 'execute'");
    }

    public Optional<Set<AccessMode>> match(String user, Set<String> roles, Set<String> groups, Optional<String> queryOwner) {
        if (this.userRegex.map(regex -> regex.matcher(user).matches()).orElse(true).booleanValue() && this.roleRegex.map(regex -> roles.stream().anyMatch(role -> regex.matcher((CharSequence)role).matches())).orElse(true).booleanValue() && this.groupRegex.map(regex -> groups.stream().anyMatch(role -> regex.matcher((CharSequence)role).matches())).orElse(true).booleanValue() && (queryOwner.isEmpty() && this.queryOwnerRegex.isEmpty() || queryOwner.isPresent() && this.queryOwnerRegex.map(regex -> regex.matcher((CharSequence)queryOwner.get()).matches()).orElse(true).booleanValue())) {
            return Optional.of(this.allow);
        }
        return Optional.empty();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("allow", this.allow).add("userRegex", this.userRegex.orElse(null)).add("roleRegex", this.roleRegex.orElse(null)).add("groupRegex", this.groupRegex.orElse(null)).add("ownerRegex", this.queryOwnerRegex.orElse(null)).toString();
    }

    public static enum AccessMode {
        EXECUTE("execute"),
        VIEW("view"),
        KILL("kill");

        private static final Map<String, AccessMode> modeByName;
        private final String stringValue;

        private AccessMode(String stringValue) {
            this.stringValue = Objects.requireNonNull(stringValue, "stringValue is null");
        }

        @JsonValue
        public String toString() {
            return this.stringValue;
        }

        @JsonCreator
        public static AccessMode fromJson(Object value) {
            String string;
            AccessMode accessMode;
            if (value instanceof String && (accessMode = modeByName.get((string = (String)value).toLowerCase(Locale.US))) != null) {
                return accessMode;
            }
            throw new IllegalArgumentException("Unknown " + AccessMode.class.getSimpleName() + ": " + String.valueOf(value));
        }

        static {
            modeByName = (Map)Arrays.stream(AccessMode.values()).collect(ImmutableMap.toImmutableMap(AccessMode::toString, Function.identity()));
        }
    }
}

