/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.base.projection.ProjectFunctionRule;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;

public abstract class AbstractRewriteCast
implements ProjectFunctionRule<JdbcExpression, ParameterizedExpression> {
    private static final Capture<Variable> VALUE = Capture.newCapture();
    private final BiFunction<ConnectorSession, Type, String> jdbcTypeProvider;

    protected abstract Optional<JdbcTypeHandle> toJdbcTypeHandle(JdbcTypeHandle var1, Type var2);

    public AbstractRewriteCast(BiFunction<ConnectorSession, Type, String> jdbcTypeProvider) {
        this.jdbcTypeProvider = Objects.requireNonNull(jdbcTypeProvider, "jdbcTypeProvider is null");
    }

    protected String buildCast(Type sourceType, Type targetType, String expression, String castType) {
        return "CAST(%s AS %s)".formatted(expression, castType);
    }

    public Pattern<Call> getPattern() {
        return ConnectorExpressionPatterns.call().with(ConnectorExpressionPatterns.functionName().equalTo((Object)StandardFunctions.CAST_FUNCTION_NAME)).with(ConnectorExpressionPatterns.argumentCount().equalTo((Object)1)).with(ConnectorExpressionPatterns.argument((int)0).matching(ConnectorExpressionPatterns.variable().capturedAs(VALUE)));
    }

    public Optional<JdbcExpression> rewrite(ConnectorTableHandle handle, ConnectorExpression castExpression, Captures captures, ProjectFunctionRule.RewriteContext<ParameterizedExpression> context) {
        Type targetType;
        Variable variable = (Variable)captures.get(VALUE);
        JdbcTypeHandle sourceTypeJdbcHandle = ((JdbcColumnHandle)context.getAssignment(variable.getName())).getJdbcTypeHandle();
        Optional<JdbcTypeHandle> targetJdbcTypeHandle = this.toJdbcTypeHandle(sourceTypeJdbcHandle, targetType = castExpression.getType());
        if (targetJdbcTypeHandle.isEmpty()) {
            return Optional.empty();
        }
        Optional value = context.rewriteExpression((ConnectorExpression)variable);
        if (value.isEmpty()) {
            return Optional.empty();
        }
        Type sourceType = variable.getType();
        String castType = this.jdbcTypeProvider.apply(context.getSession(), targetType);
        return Optional.of(new JdbcExpression(this.buildCast(sourceType, targetType, ((ParameterizedExpression)value.get()).expression(), castType), ((ParameterizedExpression)value.get()).parameters(), targetJdbcTypeHandle.get()));
    }
}

