/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.procedure;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;

public final class ExecuteProcedure
implements Provider<Procedure> {
    private static final MethodHandle EXECUTE;
    private final JdbcClient jdbcClient;

    @Inject
    public ExecuteProcedure(JdbcClient jdbcClient) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
    }

    public Procedure get() {
        return new Procedure("system", "execute", (List)ImmutableList.of((Object)new Procedure.Argument("QUERY", (Type)VarcharType.VARCHAR)), EXECUTE.bindTo(this));
    }

    public void execute(ConnectorSession session, String query) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doExecute(session, query);
        }
    }

    public void doExecute(ConnectorSession session, String query) {
        try (Connection connection = this.jdbcClient.getConnection(session);){
            connection.setReadOnly(false);
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate(query);
            }
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Failed to execute query. " + String.valueOf(MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e)), (Throwable)e);
        }
    }

    static {
        try {
            EXECUTE = MethodHandles.lookup().unreflect(ExecuteProcedure.class.getMethod("execute", ConnectorSession.class, String.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

