/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EncryptedOutputStream;
import com.exasol.jdbc.ProtocolAttribute;
import com.exasol.jdbc.SimpleDate;
import com.exasol.jdbc.StreamEncoder;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.exaTimestamp;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Calendar;

class EXAOutputStream
extends OutputStream {
    final EXAConnection connection;
    protected OutputStream father;
    private byte[] buffer;
    private Calendar defCal;
    private final char[] hexArray = "0123456789ABCDEF".toCharArray();

    EXAOutputStream(OutputStream f, EXAConnection connection) {
        this.father = f;
        this.buffer = new byte[8];
        this.defCal = Calendar.getInstance();
        this.connection = connection;
    }

    public void SetEncryptor(StreamEncoder enc) throws IOException {
        if (!(this.father instanceof EncryptedOutputStream)) {
            throw new IOException("Try to activate encryption on an OutputStream that is not an instance of EncryptedOutputStream");
        }
        ((EncryptedOutputStream)this.father).SetEncryptor(enc);
    }

    @Override
    public void close() throws IOException {
        this.father.close();
    }

    @Override
    public void flush() throws IOException {
        this.father.flush();
    }

    public void setHeader() throws IOException {
        if (this.father instanceof EncryptedOutputStream) {
            ((EncryptedOutputStream)this.father).setHeader();
        } else if (this.father instanceof EXAOutputStream) {
            ((EXAOutputStream)this.father).setHeader();
        } else {
            this.father.flush();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b != null) {
            this.father.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b != null) {
            this.father.write(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.father.write(b);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.father.write(v ? 1 : 0);
    }

    public void writeByte(byte v) throws IOException {
        this.father.write(v & 0xFF);
    }

    public void writeShort(short v) throws IOException {
        this.buffer[1] = (byte)(v >> 8);
        this.buffer[0] = (byte)v;
        this.father.write(this.buffer, 0, 2);
    }

    public void writeInt(int v) throws IOException {
        this.buffer[3] = (byte)(v >> 24);
        this.buffer[2] = (byte)(v >> 16);
        this.buffer[1] = (byte)(v >> 8);
        this.buffer[0] = (byte)v;
        this.father.write(this.buffer, 0, 4);
    }

    public void writeLong(long v) throws IOException {
        this.buffer[7] = (byte)(v >> 56);
        this.buffer[6] = (byte)(v >> 48);
        this.buffer[5] = (byte)(v >> 40);
        this.buffer[4] = (byte)(v >> 32);
        this.buffer[3] = (byte)(v >> 24);
        this.buffer[2] = (byte)(v >> 16);
        this.buffer[1] = (byte)(v >> 8);
        this.buffer[0] = (byte)v;
        this.father.write(this.buffer, 0, 8);
    }

    public void writeFloat(float f) throws IOException {
        int v = Float.floatToIntBits(f);
        this.buffer[3] = (byte)(v >> 24);
        this.buffer[2] = (byte)(v >> 16);
        this.buffer[1] = (byte)(v >> 8);
        this.buffer[0] = (byte)v;
        this.father.write(this.buffer, 0, 4);
    }

    public void writeDouble(double d) throws IOException {
        long v = Double.doubleToLongBits(d);
        this.buffer[7] = (byte)(v >> 56);
        this.buffer[6] = (byte)(v >> 48);
        this.buffer[5] = (byte)(v >> 40);
        this.buffer[4] = (byte)(v >> 32);
        this.buffer[3] = (byte)(v >> 24);
        this.buffer[2] = (byte)(v >> 16);
        this.buffer[1] = (byte)(v >> 8);
        this.buffer[0] = (byte)v;
        this.father.write(this.buffer, 0, 8);
    }

    private String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 3];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 3] = this.hexArray[v >>> 4];
            hexChars[j * 3 + 1] = this.hexArray[v & 0xF];
            hexChars[j * 3 + 2] = 32;
        }
        return new String(hexChars);
    }

    public void writeString(String s) throws IOException {
        if (s == null) {
            this.writeInt(0);
        } else {
            byte[] bytes = s.getBytes(this.connection.getEncoding());
            this.writeInt(bytes.length);
            this.write(bytes);
        }
    }

    public void writeBinary(byte[] b) throws IOException {
        if (b == null) {
            this.writeInt(0);
        } else {
            this.writeInt(b.length);
            this.write(b);
        }
    }

    public void writeNulls(int size) throws IOException {
        if (size == 0) {
            return;
        }
        this.buffer[0] = 0;
        this.buffer[1] = 0;
        this.buffer[2] = 0;
        this.buffer[3] = 0;
        this.buffer[4] = 0;
        this.buffer[5] = 0;
        this.buffer[6] = 0;
        this.buffer[7] = 0;
        while (size > 8) {
            this.father.write(this.buffer);
            size -= 8;
        }
        this.father.write(this.buffer, 0, size);
    }

    public void writeTimestamp(exaTimestamp t) throws IOException {
        int v = t.getYear();
        this.buffer[0] = (byte)v;
        this.buffer[1] = (byte)(v >> 8);
        v = t.getMonth() + 1;
        this.buffer[2] = (byte)v;
        v = t.getDay();
        this.buffer[3] = (byte)v;
        v = t.getHour();
        this.buffer[4] = (byte)v;
        v = t.getMinute();
        this.buffer[5] = (byte)v;
        v = t.getSecond();
        this.buffer[6] = (byte)v;
        this.father.write(this.buffer, 0, 7);
        this.writeInt(t.getNanos());
    }

    public void writeTimestamp(Timestamp t) throws IOException {
        this.defCal.setTimeInMillis(t.getTime());
        int v = this.defCal.get(1);
        this.buffer[0] = (byte)v;
        this.buffer[1] = (byte)(v >> 8);
        v = this.defCal.get(2) + 1;
        this.buffer[2] = (byte)v;
        v = this.defCal.get(5);
        this.buffer[3] = (byte)v;
        v = this.defCal.get(11);
        this.buffer[4] = (byte)v;
        v = this.defCal.get(12);
        this.buffer[5] = (byte)v;
        v = this.defCal.get(13);
        this.buffer[6] = (byte)v;
        this.father.write(this.buffer, 0, 7);
        this.writeInt(t.getNanos());
    }

    public void writeDate(SimpleDate d) throws IOException {
        this.writeInt(d.toInt());
        System.out.println(d.toString());
    }

    public void writeAttribute(ProtocolAttribute attrib, String value) throws IOException {
        if (attrib.type != 10) {
            throw new IOException(Translator.Attribute_type_mismatch() + attrib.id);
        }
        this.writeShort(attrib.id);
        this.writeString(value);
    }

    public void writeAttribute(ProtocolAttribute attrib, int value) throws IOException {
        if (attrib.type != 4) {
            throw new IOException(Translator.Attribute_type_mismatch() + attrib.id);
        }
        this.writeShort(attrib.id);
        this.writeInt(value);
    }

    public void writeAttribute(ProtocolAttribute attrib, long value) throws IOException {
        if (attrib.type != 5) {
            throw new IOException(Translator.Attribute_type_mismatch() + attrib.id);
        }
        this.writeShort(attrib.id);
        this.writeLong(value);
    }

    public void writeAttribute(ProtocolAttribute attrib) throws IOException {
        this.writeShort(attrib.id);
        switch (attrib.type) {
            case 0: {
                throw new IOException(Translator.Unsupported_attribute() + attrib.id);
            }
            case 10: {
                this.writeString((String)attrib.value);
                break;
            }
            case 15: {
                this.writeBinary((byte[])attrib.value);
                break;
            }
            case 4: {
                if (attrib.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + attrib.id);
                }
                this.writeInt((Integer)attrib.value);
                break;
            }
            case 1: {
                if (attrib.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + attrib.id);
                }
                this.writeByte((Byte)attrib.value);
                break;
            }
            case 9: {
                if (attrib.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + attrib.id);
                }
                this.writeBoolean((Boolean)attrib.value);
                break;
            }
            case 14: {
                if (attrib.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + attrib.id);
                }
                this.writeDate((SimpleDate)attrib.value);
                break;
            }
            case 8: {
                if (attrib.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + attrib.id);
                }
                this.writeDouble((Double)attrib.value);
                break;
            }
            case 5: {
                if (attrib.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + attrib.id);
                }
                this.writeLong((Long)attrib.value);
                break;
            }
            case 7: {
                if (attrib.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + attrib.id);
                }
                this.writeFloat(((Float)attrib.value).floatValue());
                break;
            }
            case 2: {
                if (attrib.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + attrib.id);
                }
                this.writeShort((Short)attrib.value);
                break;
            }
            case 21: {
                if (attrib.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + attrib.id);
                }
                this.writeTimestamp((Timestamp)attrib.value);
                break;
            }
            case 64: {
                if (attrib.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + attrib.id);
                }
                this.writeBigInteger(((BigDecimal)attrib.value).unscaledValue());
                break;
            }
            default: {
                throw new IOException(Translator.Unsupported_type_of_attribute_value_for_attribute() + attrib.id);
            }
        }
    }

    public void writeBigInteger(BigInteger unscaled) throws IOException {
        int i;
        byte[] bytes = unscaled.toByteArray();
        if (bytes.length > 16) {
            throw new IOException(Translator.Numeric_value_too_big_for_bigdecimal());
        }
        for (i = bytes.length - 1; i >= 0; --i) {
            this.write(bytes[i]);
        }
        if (unscaled.signum() >= 0) {
            for (i = bytes.length; i < 16; ++i) {
                this.write(0);
            }
        } else {
            for (i = bytes.length; i < 16; ++i) {
                this.write(-1);
            }
        }
    }

    public String getEncoding() {
        return this.connection.getEncoding();
    }
}

