/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAResult;
import com.exasol.jdbc.EXAResultSet;
import com.exasol.jdbc.ExceptionFactory;
import java.io.IOException;
import java.sql.SQLException;

public class EXASQLException
extends EXAResult {
    private String code;
    private String message;

    public EXASQLException(EXAInputStream is, DebugLog debug) throws IOException {
        super("EXASQLException", debug);
        this.message = is.readString();
        byte[] bytes = new byte[5];
        is.read(bytes);
        this.code = new String(bytes);
        if (debug != null) {
            debug.log("created EXASQLException [" + this.code + "]: " + this.message);
        }
    }

    public EXASQLException(String cd, String msg, DebugLog debug) throws IOException {
        super("EXASQLException", debug);
        this.message = msg;
        this.code = cd;
        if (debug != null) {
            debug.log("created EXASQLException [" + this.code + "]: " + this.message);
        }
    }

    public String getSQLCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public SQLException getSQLException() {
        return ExceptionFactory.createSQLException(this.getMessage(), this.getSQLCode(), this.connection);
    }

    protected SQLException getSQLExceptionIntern(EXAConnection conn) {
        this.connection = conn;
        return ExceptionFactory.createSQLException(this.getMessage(), this.getSQLCode(), this.connection);
    }

    @Override
    public EXAResultSet toResultSet() {
        String[] values = new String[]{this.message};
        return this.connection.dialectFactory.createResultSet("Exception", values, this.debug);
    }
}

