/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.cert.ocsp;

import java.util.Date;
import resources.dependencies.org.bouncycastle.asn1.ASN1Sequence;
import resources.dependencies.org.bouncycastle.asn1.ocsp.ResponseData;
import resources.dependencies.org.bouncycastle.asn1.ocsp.SingleResponse;
import resources.dependencies.org.bouncycastle.asn1.x509.Extensions;
import resources.dependencies.org.bouncycastle.cert.ocsp.OCSPUtils;
import resources.dependencies.org.bouncycastle.cert.ocsp.RespID;
import resources.dependencies.org.bouncycastle.cert.ocsp.SingleResp;

public class RespData {
    private ResponseData data;

    public RespData(ResponseData responseData) {
        this.data = responseData;
    }

    public int getVersion() {
        return this.data.getVersion().intValueExact() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.data.getResponderID());
    }

    public Date getProducedAt() {
        return OCSPUtils.extractDate(this.data.getProducedAt());
    }

    public SingleResp[] getResponses() {
        ASN1Sequence aSN1Sequence = this.data.getResponses();
        SingleResp[] singleRespArray = new SingleResp[aSN1Sequence.size()];
        for (int i = 0; i != singleRespArray.length; ++i) {
            singleRespArray[i] = new SingleResp(SingleResponse.getInstance(aSN1Sequence.getObjectAt(i)));
        }
        return singleRespArray;
    }

    public Extensions getResponseExtensions() {
        return this.data.getResponseExtensions();
    }
}

