/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exasol;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongReadFunction;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ColumnPosition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Type;
import java.sql.Connection;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;

public class ExasolClient
extends BaseJdbcClient {
    private static final Set<String> INTERNAL_SCHEMAS = ImmutableSet.builder().add((Object)"EXA_STATISTICS").add((Object)"SYS").build();

    @Inject
    public ExasolClient(BaseJdbcConfig config, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, IdentifierMapping identifierMapping, RemoteQueryModifier queryModifier) {
        super("\"", connectionFactory, queryBuilder, config.getJdbcTypesMappedToVarchar(), identifierMapping, queryModifier, false);
    }

    protected boolean filterSchema(String schemaName) {
        if (INTERNAL_SCHEMAS.contains(schemaName.toUpperCase(Locale.ENGLISH))) {
            return false;
        }
        return super.filterSchema(schemaName);
    }

    public OptionalLong delete(ConnectorSession session, JdbcTableHandle handle) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support modifying table rows");
    }

    public void truncateTable(ConnectorSession session, JdbcTableHandle handle) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support truncating tables");
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables");
    }

    public void commitCreateTable(ConnectorSession session, JdbcOutputTableHandle handle, Set<Long> pageSinkIds) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables");
    }

    public void addColumn(ConnectorSession session, JdbcTableHandle handle, ColumnMetadata column, ColumnPosition position) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding columns");
    }

    public void renameColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming columns");
    }

    public void setColumnType(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Type type) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setting column types");
    }

    public void dropColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping columns");
    }

    public void dropTable(ConnectorSession session, JdbcTableHandle handle) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping tables");
    }

    public void rollbackCreateTable(ConnectorSession session, JdbcOutputTableHandle handle) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables");
    }

    public String buildInsertSql(JdbcOutputTableHandle handle, List<WriteFunction> columnWriters) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support inserts");
    }

    public void createSchema(ConnectorSession session, String schemaName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating schemas");
    }

    public void dropSchema(ConnectorSession session, String schemaName, boolean cascade) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping schemas");
    }

    public void renameSchema(ConnectorSession session, String schemaName, String newSchemaName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming schemas");
    }

    protected void renameTable(ConnectorSession session, Connection connection, String catalogName, String remoteSchemaName, String remoteTableName, String newRemoteSchemaName, String newRemoteTableName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming tables");
    }

    protected boolean isSupportedJoinCondition(ConnectorSession session, JdbcJoinCondition joinCondition) {
        return false;
    }

    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return Optional.empty();
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        switch (typeHandle.jdbcType()) {
            case 16: {
                return Optional.of(StandardColumnMappings.booleanColumnMapping());
            }
            case 5: {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case 4: {
                return Optional.of(StandardColumnMappings.integerColumnMapping());
            }
            case -5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case 3: {
                int decimalDigits = typeHandle.requiredDecimalDigits();
                int columnSize = typeHandle.requiredColumnSize();
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)columnSize, (int)decimalDigits)));
            }
            case 1: {
                return Optional.of(StandardColumnMappings.defaultCharColumnMapping((int)typeHandle.requiredColumnSize(), (boolean)true));
            }
            case 12: {
                return Optional.of(StandardColumnMappings.defaultVarcharColumnMapping((int)typeHandle.requiredColumnSize(), (boolean)true));
            }
            case 91: {
                return Optional.of(ExasolClient.dateColumnMapping());
            }
        }
        if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
            return ExasolClient.mapToUnboundedVarchar((JdbcTypeHandle)typeHandle);
        }
        return Optional.empty();
    }

    private static ColumnMapping dateColumnMapping() {
        return ColumnMapping.longMapping((Type)DateType.DATE, (LongReadFunction)ExasolClient.dateReadFunctionUsingSqlDate(), (LongWriteFunction)ExasolClient.dateWriteFunctionUsingSqlDate());
    }

    private static LongReadFunction dateReadFunctionUsingSqlDate() {
        return (resultSet, columnIndex) -> {
            Date date = resultSet.getDate(columnIndex);
            return date.toLocalDate().toEpochDay();
        };
    }

    private static LongWriteFunction dateWriteFunctionUsingSqlDate() {
        return LongWriteFunction.of((int)91, (statement, index, value) -> {
            LocalDate localDate = LocalDate.ofEpochDay(value);
            statement.setDate(index, Date.valueOf(localDate));
        });
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support writing");
    }

    public JdbcOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables with data");
    }

    public JdbcOutputTableHandle beginInsertTable(ConnectorSession session, JdbcTableHandle tableHandle, List<JdbcColumnHandle> columns) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support inserts");
    }
}

