/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import javax.crypto.SecretKey;

@Immutable
public class ExchangeSourceFile {
    private final URI fileUri;
    private final Optional<SecretKey> secretKey;
    private final long fileSize;

    public ExchangeSourceFile(URI fileUri, Optional<SecretKey> secretKey, long fileSize) {
        this.fileUri = Objects.requireNonNull(fileUri, "fileUri is null");
        this.secretKey = Objects.requireNonNull(secretKey, "secretKey is null");
        this.fileSize = fileSize;
    }

    public URI getFileUri() {
        return this.fileUri;
    }

    public Optional<SecretKey> getSecretKey() {
        return this.secretKey;
    }

    public long getFileSize() {
        return this.fileSize;
    }
}

