/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.AsyncSemaphore;
import io.trino.plugin.exchange.filesystem.FileStatus;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeSinkHandle;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeSinkInstanceHandle;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeSourceHandle;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeStats;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeStorage;
import io.trino.spi.exchange.Exchange;
import io.trino.spi.exchange.ExchangeContext;
import io.trino.spi.exchange.ExchangeSinkHandle;
import io.trino.spi.exchange.ExchangeSinkInstanceHandle;
import io.trino.spi.exchange.ExchangeSourceHandle;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;
import javax.crypto.SecretKey;

public class FileSystemExchange
implements Exchange {
    private static final Pattern PARTITION_FILE_NAME_PATTERN = Pattern.compile("(\\d+)_(\\d+)\\.data");
    private static final char[] RANDOMIZED_HEX_PREFIX_ALPHABET = "abcdef0123456789".toCharArray();
    private static final int RANDOMIZED_HEX_PREFIX_LENGTH = 6;
    private final List<URI> baseDirectories;
    private final FileSystemExchangeStorage exchangeStorage;
    private final FileSystemExchangeStats stats;
    private final ExchangeContext exchangeContext;
    private final int outputPartitionCount;
    private final boolean preserveOrderWithinPartition;
    private final int fileListingParallelism;
    private final Optional<SecretKey> secretKey;
    private final long exchangeSourceHandleTargetDataSizeInBytes;
    private final ExecutorService executor;
    private final Map<Integer, URI> outputDirectories = new ConcurrentHashMap<Integer, URI>();
    @GuardedBy(value="this")
    private final Set<Integer> allSinks = new HashSet<Integer>();
    @GuardedBy(value="this")
    private final Set<Integer> finishedSinks = new HashSet<Integer>();
    @GuardedBy(value="this")
    private boolean noMoreSinks;
    @GuardedBy(value="this")
    private boolean exchangeSourceHandlesCreationStarted;
    private final CompletableFuture<List<ExchangeSourceHandle>> exchangeSourceHandlesFuture = new CompletableFuture();

    public FileSystemExchange(List<URI> baseDirectories, FileSystemExchangeStorage exchangeStorage, FileSystemExchangeStats stats, ExchangeContext exchangeContext, int outputPartitionCount, boolean preserveOrderWithinPartition, int fileListingParallelism, Optional<SecretKey> secretKey, long exchangeSourceHandleTargetDataSizeInBytes, ExecutorService executor) {
        ArrayList directories = new ArrayList(Objects.requireNonNull(baseDirectories, "baseDirectories is null"));
        Collections.shuffle(directories);
        this.baseDirectories = ImmutableList.copyOf(directories);
        this.exchangeStorage = Objects.requireNonNull(exchangeStorage, "exchangeStorage is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.exchangeContext = Objects.requireNonNull(exchangeContext, "exchangeContext is null");
        this.outputPartitionCount = outputPartitionCount;
        this.preserveOrderWithinPartition = preserveOrderWithinPartition;
        this.fileListingParallelism = fileListingParallelism;
        this.secretKey = Objects.requireNonNull(secretKey, "secretKey is null");
        this.exchangeSourceHandleTargetDataSizeInBytes = exchangeSourceHandleTargetDataSizeInBytes;
        this.executor = Objects.requireNonNull(executor, "executor is null");
    }

    public synchronized ExchangeSinkHandle addSink(int taskPartition) {
        FileSystemExchangeSinkHandle sinkHandle = new FileSystemExchangeSinkHandle(taskPartition, this.secretKey.map(Key::getEncoded));
        this.allSinks.add(taskPartition);
        return sinkHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noMoreSinks() {
        FileSystemExchange fileSystemExchange = this;
        synchronized (fileSystemExchange) {
            this.noMoreSinks = true;
        }
        this.checkInputReady();
    }

    public ExchangeSinkInstanceHandle instantiateSink(ExchangeSinkHandle sinkHandle, int taskAttemptId) {
        FileSystemExchangeSinkHandle fileSystemExchangeSinkHandle = (FileSystemExchangeSinkHandle)sinkHandle;
        int taskPartitionId = fileSystemExchangeSinkHandle.getPartitionId();
        URI outputDirectory = this.getTaskOutputDirectory(taskPartitionId).resolve(taskAttemptId + "/");
        try {
            this.exchangeStorage.createDirectories(outputDirectory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new FileSystemExchangeSinkInstanceHandle(fileSystemExchangeSinkHandle, outputDirectory, this.outputPartitionCount, this.preserveOrderWithinPartition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sinkFinished(ExchangeSinkInstanceHandle handle) {
        FileSystemExchange fileSystemExchange = this;
        synchronized (fileSystemExchange) {
            FileSystemExchangeSinkInstanceHandle instanceHandle = (FileSystemExchangeSinkInstanceHandle)handle;
            this.finishedSinks.add(instanceHandle.getSinkHandle().getPartitionId());
        }
        this.checkInputReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInputReady() {
        Verify.verify((!Thread.holdsLock(this) ? 1 : 0) != 0);
        ListenableFuture exchangeSourceHandlesCreationFuture = null;
        FileSystemExchange fileSystemExchange = this;
        synchronized (fileSystemExchange) {
            if (this.exchangeSourceHandlesCreationStarted) {
                return;
            }
            if (this.noMoreSinks && this.finishedSinks.containsAll(this.allSinks)) {
                this.exchangeSourceHandlesCreationStarted = true;
                exchangeSourceHandlesCreationFuture = this.stats.getCreateExchangeSourceHandles().record(this::createExchangeSourceHandles);
                this.exchangeSourceHandlesFuture.whenComplete((value, failure) -> {
                    if (this.exchangeSourceHandlesFuture.isCancelled()) {
                        this.exchangeSourceHandlesFuture.cancel(true);
                    }
                });
            }
        }
        if (exchangeSourceHandlesCreationFuture != null) {
            Futures.addCallback(exchangeSourceHandlesCreationFuture, (FutureCallback)new FutureCallback<List<ExchangeSourceHandle>>(){

                public void onSuccess(List<ExchangeSourceHandle> exchangeSourceHandles) {
                    FileSystemExchange.this.exchangeSourceHandlesFuture.complete(exchangeSourceHandles);
                }

                public void onFailure(Throwable throwable) {
                    FileSystemExchange.this.exchangeSourceHandlesFuture.completeExceptionally(throwable);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<List<ExchangeSourceHandle>> createExchangeSourceHandles() {
        ImmutableList finishedTaskPartitions;
        FileSystemExchange fileSystemExchange = this;
        synchronized (fileSystemExchange) {
            finishedTaskPartitions = ImmutableList.copyOf(this.finishedSinks);
        }
        return Futures.transform((ListenableFuture)AsyncSemaphore.processAll((List)finishedTaskPartitions, this::getCommittedPartitions, (int)this.fileListingParallelism, (Executor)this.executor), partitionsList -> {
            ArrayListMultimap partitionFiles = ArrayListMultimap.create();
            partitionsList.forEach(arg_0 -> FileSystemExchange.lambda$createExchangeSourceHandles$1((Multimap)partitionFiles, arg_0));
            ImmutableList.Builder result = ImmutableList.builder();
            for (Integer partitionId : partitionFiles.keySet()) {
                Collection files = partitionFiles.get((Object)partitionId);
                long currentExchangeHandleDataSizeInBytes = 0L;
                ImmutableList.Builder currentExchangeHandleFiles = ImmutableList.builder();
                for (FileStatus file : files) {
                    if (currentExchangeHandleDataSizeInBytes > 0L && currentExchangeHandleDataSizeInBytes + file.getFileSize() > this.exchangeSourceHandleTargetDataSizeInBytes) {
                        result.add((Object)new FileSystemExchangeSourceHandle(partitionId, (List<FileStatus>)currentExchangeHandleFiles.build(), this.secretKey.map(Key::getEncoded)));
                        currentExchangeHandleDataSizeInBytes = 0L;
                        currentExchangeHandleFiles = ImmutableList.builder();
                    }
                    currentExchangeHandleDataSizeInBytes += file.getFileSize();
                    currentExchangeHandleFiles.add((Object)file);
                }
                if (currentExchangeHandleDataSizeInBytes <= 0L) continue;
                result.add((Object)new FileSystemExchangeSourceHandle(partitionId, (List<FileStatus>)currentExchangeHandleFiles.build(), this.secretKey.map(Key::getEncoded)));
            }
            return result.build();
        }, (Executor)this.executor);
    }

    private ListenableFuture<Multimap<Integer, FileStatus>> getCommittedPartitions(int taskPartitionId) {
        URI sinkOutputPath = this.getTaskOutputDirectory(taskPartitionId);
        return this.stats.getGetCommittedPartitions().record(Futures.transform(this.exchangeStorage.listFilesRecursively(sinkOutputPath), sinkOutputFiles -> {
            String committedMarkerFilePath = sinkOutputFiles.stream().map(FileStatus::getFilePath).filter(filePath -> filePath.endsWith("committed")).findFirst().orElseThrow(() -> new IllegalStateException(String.format("No committed attempts found under sink output path %s", sinkOutputPath)));
            String[] parts = committedMarkerFilePath.split("/");
            Preconditions.checkState((parts.length >= 3 ? 1 : 0) != 0, (String)"committedMarkerFilePath %s is malformed", (Object)committedMarkerFilePath);
            String committedAttemptId = parts[parts.length - 2];
            int attemptIdOffset = committedMarkerFilePath.length() - committedAttemptId.length() - "/".length() - "committed".length();
            List partitionFiles = (List)sinkOutputFiles.stream().filter(file -> file.getFilePath().startsWith(committedAttemptId + "/", attemptIdOffset) && file.getFilePath().endsWith(".data")).collect(ImmutableList.toImmutableList());
            ImmutableMultimap.Builder result = ImmutableMultimap.builder();
            for (FileStatus partitionFile : partitionFiles) {
                Matcher matcher = PARTITION_FILE_NAME_PATTERN.matcher(new File(partitionFile.getFilePath()).getName());
                Preconditions.checkState((boolean)matcher.matches(), (String)"Unexpected partition file: %s", (Object)partitionFile);
                int partitionId = Integer.parseInt(matcher.group(1));
                result.put((Object)partitionId, (Object)partitionFile);
            }
            return result.build();
        }, (Executor)this.executor));
    }

    private URI getTaskOutputDirectory(int taskPartitionId) {
        return this.outputDirectories.computeIfAbsent(taskPartitionId, ignored -> this.baseDirectories.get(ThreadLocalRandom.current().nextInt(this.baseDirectories.size())).resolve(FileSystemExchange.generateRandomizedHexPrefix() + "." + this.exchangeContext.getQueryId() + "." + this.exchangeContext.getExchangeId() + "." + taskPartitionId + "/"));
    }

    public CompletableFuture<List<ExchangeSourceHandle>> getSourceHandles() {
        return this.exchangeSourceHandlesFuture;
    }

    public void close() {
        this.stats.getCloseExchange().record(this.exchangeStorage.deleteRecursively((List)this.allSinks.stream().map(this::getTaskOutputDirectory).collect(ImmutableList.toImmutableList())));
    }

    private static String generateRandomizedHexPrefix() {
        char[] value = new char[6];
        for (int i = 0; i < value.length; ++i) {
            value[i] = RANDOMIZED_HEX_PREFIX_ALPHABET[ThreadLocalRandom.current().nextInt(RANDOMIZED_HEX_PREFIX_ALPHABET.length)];
        }
        return new String(value);
    }

    private static /* synthetic */ void lambda$createExchangeSourceHandles$1(Multimap partitionFiles, Multimap partitions) {
        partitions.forEach((arg_0, arg_1) -> ((Multimap)partitionFiles).put(arg_0, arg_1));
    }
}

