/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.trino.plugin.exchange.filesystem.ExchangeSourceFile;
import io.trino.plugin.exchange.filesystem.FileSystemExchange;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeConfig;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeErrorCode;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeSink;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeSinkInstanceHandle;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeSource;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeSourceHandle;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeStats;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeStorage;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.exchange.Exchange;
import io.trino.spi.exchange.ExchangeContext;
import io.trino.spi.exchange.ExchangeManager;
import io.trino.spi.exchange.ExchangeSink;
import io.trino.spi.exchange.ExchangeSinkInstanceHandle;
import io.trino.spi.exchange.ExchangeSource;
import io.trino.spi.exchange.ExchangeSourceHandle;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;

public class FileSystemExchangeManager
implements ExchangeManager {
    public static final String PATH_SEPARATOR = "/";
    private static final int KEY_BITS = 256;
    private final FileSystemExchangeStorage exchangeStorage;
    private final FileSystemExchangeStats stats;
    private final List<URI> baseDirectories;
    private final boolean exchangeEncryptionEnabled;
    private final int maxPageStorageSizeInBytes;
    private final int exchangeSinkBufferPoolMinSize;
    private final int exchangeSinkBuffersPerPartition;
    private final long exchangeSinkMaxFileSizeInBytes;
    private final int exchangeSourceConcurrentReaders;
    private final int maxOutputPartitionCount;
    private final int exchangeFileListingParallelism;
    private final long exchangeSourceHandleTargetDataSizeInBytes;
    private final ExecutorService executor;

    @Inject
    public FileSystemExchangeManager(FileSystemExchangeStorage exchangeStorage, FileSystemExchangeStats stats, FileSystemExchangeConfig fileSystemExchangeConfig) {
        Objects.requireNonNull(fileSystemExchangeConfig, "fileSystemExchangeConfig is null");
        this.exchangeStorage = Objects.requireNonNull(exchangeStorage, "exchangeStorage is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.baseDirectories = ImmutableList.copyOf((Collection)Objects.requireNonNull(fileSystemExchangeConfig.getBaseDirectories(), "baseDirectories is null"));
        this.exchangeEncryptionEnabled = fileSystemExchangeConfig.isExchangeEncryptionEnabled();
        this.maxPageStorageSizeInBytes = Math.toIntExact(fileSystemExchangeConfig.getMaxPageStorageSize().toBytes());
        this.exchangeSinkBufferPoolMinSize = fileSystemExchangeConfig.getExchangeSinkBufferPoolMinSize();
        this.exchangeSinkBuffersPerPartition = fileSystemExchangeConfig.getExchangeSinkBuffersPerPartition();
        this.exchangeSinkMaxFileSizeInBytes = fileSystemExchangeConfig.getExchangeSinkMaxFileSize().toBytes();
        this.exchangeSourceConcurrentReaders = fileSystemExchangeConfig.getExchangeSourceConcurrentReaders();
        this.maxOutputPartitionCount = fileSystemExchangeConfig.getMaxOutputPartitionCount();
        this.exchangeFileListingParallelism = fileSystemExchangeConfig.getExchangeFileListingParallelism();
        this.exchangeSourceHandleTargetDataSizeInBytes = fileSystemExchangeConfig.getExchangeSourceHandleTargetDataSize().toBytes();
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"exchange-source-handles-creation-%s"));
    }

    public Exchange createExchange(ExchangeContext context, int outputPartitionCount, boolean preserveOrderWithinPartition) {
        if (outputPartitionCount > this.maxOutputPartitionCount) {
            throw new TrinoException((ErrorCodeSupplier)FileSystemExchangeErrorCode.MAX_OUTPUT_PARTITION_COUNT_EXCEEDED, String.format("Max number of output partitions exceeded for exchange '%s'. Allowed: %s. Requested: %s.", context.getExchangeId(), this.maxOutputPartitionCount, outputPartitionCount));
        }
        Optional<SecretKey> secretKey = Optional.empty();
        if (this.exchangeEncryptionEnabled) {
            try {
                KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
                keyGenerator.init(256);
                secretKey = Optional.of(keyGenerator.generateKey());
            }
            catch (NoSuchAlgorithmException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to generate new secret key: " + e.getMessage(), (Throwable)e);
            }
        }
        return new FileSystemExchange(this.baseDirectories, this.exchangeStorage, this.stats, context, outputPartitionCount, preserveOrderWithinPartition, this.exchangeFileListingParallelism, secretKey, this.exchangeSourceHandleTargetDataSizeInBytes, this.executor);
    }

    public ExchangeSink createSink(ExchangeSinkInstanceHandle handle) {
        FileSystemExchangeSinkInstanceHandle instanceHandle = (FileSystemExchangeSinkInstanceHandle)handle;
        return new FileSystemExchangeSink(this.exchangeStorage, this.stats, instanceHandle.getOutputDirectory(), instanceHandle.getOutputPartitionCount(), instanceHandle.getSinkHandle().getSecretKey().map(key -> new SecretKeySpec((byte[])key, 0, ((byte[])key).length, "AES")), instanceHandle.isPreserveOrderWithinPartition(), this.maxPageStorageSizeInBytes, this.exchangeSinkBufferPoolMinSize, this.exchangeSinkBuffersPerPartition, this.exchangeSinkMaxFileSizeInBytes);
    }

    public ExchangeSource createSource(List<ExchangeSourceHandle> handles) {
        List sourceFiles = (List)handles.stream().map(FileSystemExchangeSourceHandle.class::cast).map(handle -> {
            Optional<SecretKey> secretKey = handle.getSecretKey().map(key -> new SecretKeySpec((byte[])key, 0, ((byte[])key).length, "AES"));
            return new AbstractMap.SimpleEntry<FileSystemExchangeSourceHandle, Optional<SecretKey>>((FileSystemExchangeSourceHandle)handle, secretKey);
        }).flatMap(entry -> ((FileSystemExchangeSourceHandle)entry.getKey()).getFiles().stream().map(fileStatus -> new ExchangeSourceFile(URI.create(fileStatus.getFilePath()), (Optional)entry.getValue(), fileStatus.getFileSize()))).collect(ImmutableList.toImmutableList());
        return new FileSystemExchangeSource(this.exchangeStorage, this.stats, sourceFiles, this.maxPageStorageSizeInBytes, this.exchangeSourceConcurrentReaders);
    }
}

