/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slice;
import io.trino.plugin.exchange.filesystem.ExchangeSourceFile;
import io.trino.plugin.exchange.filesystem.ExchangeStorageReader;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeStats;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeStorage;
import io.trino.spi.exchange.ExchangeSource;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public class FileSystemExchangeSource
implements ExchangeSource {
    private final FileSystemExchangeStats stats;
    private final List<ExchangeStorageReader> readers;
    private volatile CompletableFuture<Void> blocked;
    private volatile boolean closed;

    public FileSystemExchangeSource(FileSystemExchangeStorage exchangeStorage, FileSystemExchangeStats stats, List<ExchangeSourceFile> sourceFiles, int maxPageStorageSize, int exchangeSourceConcurrentReaders) {
        Objects.requireNonNull(exchangeStorage, "exchangeStorage is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        ArrayBlockingQueue<ExchangeSourceFile> sourceFileQueue = new ArrayBlockingQueue<ExchangeSourceFile>(sourceFiles.size());
        sourceFileQueue.addAll(sourceFiles);
        int numReaders = Math.min(sourceFiles.size(), exchangeSourceConcurrentReaders);
        ImmutableList.Builder readers = ImmutableList.builder();
        for (int i = 0; i < numReaders; ++i) {
            readers.add((Object)exchangeStorage.createExchangeStorageReader(sourceFileQueue, maxPageStorageSize));
        }
        this.readers = readers.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> isBlocked() {
        CompletableFuture<Void> blocked = this.blocked;
        if (blocked != null && !blocked.isDone()) {
            return blocked;
        }
        for (ExchangeStorageReader reader : this.readers) {
            if (!reader.isBlocked().isDone()) continue;
            return NOT_BLOCKED;
        }
        FileSystemExchangeSource fileSystemExchangeSource = this;
        synchronized (fileSystemExchangeSource) {
            if (this.blocked == null || this.blocked.isDone()) {
                this.blocked = this.stats.getExchangeSourceBlocked().record(MoreFutures.toCompletableFuture((ListenableFuture)Futures.nonCancellationPropagating((ListenableFuture)MoreFutures.whenAnyComplete((Iterable)((Iterable)this.readers.stream().map(ExchangeStorageReader::isBlocked).collect(ImmutableList.toImmutableList()))))));
            }
            return this.blocked;
        }
    }

    public boolean isFinished() {
        if (this.closed) {
            return true;
        }
        for (ExchangeStorageReader reader : this.readers) {
            if (reader.isFinished()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Slice read() {
        if (this.closed) {
            return null;
        }
        for (ExchangeStorageReader reader : this.readers) {
            if (!reader.isBlocked().isDone() || reader.isFinished()) continue;
            try {
                return reader.read();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return null;
    }

    public long getMemoryUsage() {
        long memoryUsage = 0L;
        for (ExchangeStorageReader reader : this.readers) {
            memoryUsage += reader.getRetainedSize();
        }
        return memoryUsage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        FileSystemExchangeSource fileSystemExchangeSource = this;
        synchronized (fileSystemExchangeSource) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.readers.forEach(ExchangeStorageReader::close);
    }
}

