/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.plugin.exchange.filesystem.FileStatus;
import io.trino.spi.exchange.ExchangeSourceHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class FileSystemExchangeSourceHandle
implements ExchangeSourceHandle {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(FileSystemExchangeSourceHandle.class).instanceSize();
    private final int partitionId;
    private final List<FileStatus> files;
    private final Optional<byte[]> secretKey;

    @JsonCreator
    public FileSystemExchangeSourceHandle(@JsonProperty(value="partitionId") int partitionId, @JsonProperty(value="files") List<FileStatus> files, @JsonProperty(value="secretKey") Optional<byte[]> secretKey) {
        this.partitionId = partitionId;
        this.files = ImmutableList.copyOf((Collection)Objects.requireNonNull(files, "files is null"));
        this.secretKey = Objects.requireNonNull(secretKey, "secretKey is null");
    }

    @JsonProperty
    public int getPartitionId() {
        return this.partitionId;
    }

    public long getDataSizeInBytes() {
        return this.files.stream().mapToLong(FileStatus::getFileSize).sum();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.files, FileStatus::getRetainedSizeInBytes) + SizeOf.sizeOf(this.secretKey, SizeOf::sizeOf);
    }

    @JsonProperty
    public List<FileStatus> getFiles() {
        return this.files;
    }

    @JsonProperty
    public Optional<byte[]> getSecretKey() {
        return this.secretKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystemExchangeSourceHandle that = (FileSystemExchangeSourceHandle)o;
        if (this.secretKey.isPresent() && that.secretKey.isPresent()) {
            return this.partitionId == that.getPartitionId() && Arrays.equals(this.secretKey.get(), that.secretKey.get());
        }
        return this.partitionId == that.getPartitionId() && this.secretKey.isEmpty() && that.secretKey.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.partitionId, this.files, this.secretKey);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionId", this.partitionId).add("files", this.files).add("secretKey", this.secretKey.map(value -> "[REDACTED]")).toString();
    }
}

