/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.batch;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.batch.BlobBatchOperationInfo;
import com.azure.storage.blob.batch.BlobBatchOperationResponse;
import com.azure.storage.blob.batch.BlobBatchStorageException;
import com.azure.storage.blob.models.BlobStorageException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class BlobBatchHelper {
    static final String HTTP_NEWLINE = "\r\n";
    private static final Pattern CONTENT_ID_PATTERN = Pattern.compile("Content-ID:\\s?(\\d+)", 2);
    private static final Pattern STATUS_CODE_PATTERN = Pattern.compile("HTTP\\/\\d\\.\\d\\s?(\\d+)\\s?\\w+", 2);
    private static final Pattern APPLICATION_HTTP_PATTERN = Pattern.compile("application\\/http", 2);
    private static final Pattern HTTP_NEWLINE_PATTERN = Pattern.compile("\r\n");
    private static final Pattern HTTP_DOUBLE_NEWLINE_PATTERN = Pattern.compile("\r\n" + HTTP_NEWLINE_PATTERN);
    private static final Pattern HTTP_HEADER_SPLIT_PATTERN = Pattern.compile(":\\s*");

    BlobBatchHelper() {
    }

    static Mono<SimpleResponse<Void>> mapBatchResponse(BlobBatchOperationInfo batchOperationInfo, Response<Flux<ByteBuffer>> rawResponse, boolean throwOnAnyFailure, ClientLogger logger) {
        String contentType = rawResponse.getHeaders().getValue("Content-Type");
        String[] boundaryPieces = contentType.split("=", 2);
        if (boundaryPieces.length == 1) {
            return Mono.error((Throwable)logger.logExceptionAsError((RuntimeException)new IllegalStateException("Response doesn't contain a boundary.")));
        }
        String boundary = boundaryPieces[1];
        return FluxUtil.collectBytesInByteBufferStream((Flux)((Flux)rawResponse.getValue())).flatMap(byteArrayBody -> Mono.create(sink -> {
            String body = new String((byte[])byteArrayBody, StandardCharsets.UTF_8);
            ArrayList<BlobStorageException> exceptions = new ArrayList<BlobStorageException>();
            String[] subResponses = body.split("--" + boundary);
            if (subResponses.length == 3 && batchOperationInfo.getOperationCount() != 1) {
                String[] exceptionSections = HTTP_DOUBLE_NEWLINE_PATTERN.split(subResponses[1]);
                int statusCode = BlobBatchHelper.getStatusCode(exceptionSections[1], logger);
                HttpHeaders headers = BlobBatchHelper.getHttpHeaders(exceptionSections[1]);
                sink.error((Throwable)logger.logExceptionAsError((RuntimeException)new BlobStorageException(headers.getValue("x-ms-error-code"), BlobBatchHelper.createHttpResponse(rawResponse.getRequest(), statusCode, headers, body), (Object)body)));
            }
            for (String subResponse : subResponses) {
                if (!APPLICATION_HTTP_PATTERN.matcher(subResponse).find()) continue;
                String[] subResponseSections = HTTP_DOUBLE_NEWLINE_PATTERN.split(subResponse);
                BlobBatchOperationResponse<?> batchOperationResponse = BlobBatchHelper.getBatchOperation(batchOperationInfo, subResponseSections[0], logger);
                batchOperationResponse.setStatusCode(BlobBatchHelper.getStatusCode(subResponseSections[1], logger));
                batchOperationResponse.setHeaders(BlobBatchHelper.getHttpHeaders(subResponseSections[1]));
                if (subResponseSections.length <= 2) continue;
                BlobBatchHelper.setBodyOrAddException(batchOperationResponse, subResponseSections[2], exceptions, logger);
            }
            if (throwOnAnyFailure && exceptions.size() != 0) {
                sink.error((Throwable)logger.logExceptionAsError((RuntimeException)((Object)new BlobBatchStorageException("Batch had operation failures.", BlobBatchHelper.createHttpResponse(rawResponse), exceptions))));
            }
            sink.success((Object)new SimpleResponse(rawResponse, null));
        }));
    }

    private static BlobBatchOperationResponse<?> getBatchOperation(BlobBatchOperationInfo batchOperationInfo, String responseBatchInfo, ClientLogger logger) {
        Matcher contentIdMatcher = CONTENT_ID_PATTERN.matcher(responseBatchInfo);
        if (!contentIdMatcher.find() || contentIdMatcher.groupCount() < 1) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalStateException("Batch operation response doesn't contain a 'Content-Id' header."));
        }
        int contentId = Integer.parseInt(contentIdMatcher.group(1));
        return batchOperationInfo.getBatchRequest(contentId).setResponseReceived();
    }

    private static int getStatusCode(String responseMetadata, ClientLogger logger) {
        Matcher statusCodeMatcher = STATUS_CODE_PATTERN.matcher(responseMetadata);
        if (statusCodeMatcher.find()) {
            return Integer.parseInt(statusCodeMatcher.group(1));
        }
        throw logger.logExceptionAsError((RuntimeException)new IllegalStateException("Unable to parse response status code."));
    }

    private static HttpHeaders getHttpHeaders(String responseMetadata) {
        HttpHeaders headers = new HttpHeaders();
        for (String line : HTTP_NEWLINE_PATTERN.split(responseMetadata)) {
            if (CoreUtils.isNullOrEmpty((CharSequence)line) || line.startsWith("HTTP") && !line.contains(":")) continue;
            String[] headerPieces = HTTP_HEADER_SPLIT_PATTERN.split(line, 2);
            if (headerPieces.length == 1) {
                headers.set(headerPieces[0], (String)null);
                continue;
            }
            headers.set(headerPieces[0], headerPieces[1]);
        }
        return headers;
    }

    private static void setBodyOrAddException(BlobBatchOperationResponse<?> batchOperationResponse, String responseBody, List<BlobStorageException> exceptions, ClientLogger logger) {
        BlobStorageException exception = new BlobStorageException(responseBody, batchOperationResponse.asHttpResponse(responseBody), (Object)responseBody);
        logger.logExceptionAsError((RuntimeException)exception);
        batchOperationResponse.setException(exception);
        exceptions.add(exception);
    }

    static HttpResponse createHttpResponse(HttpRequest request, final int statusCode, final HttpHeaders headers, final String body) {
        return new HttpResponse(request){

            public int getStatusCode() {
                return statusCode;
            }

            public String getHeaderValue(String name) {
                return headers.getValue(name);
            }

            public HttpHeaders getHeaders() {
                return headers;
            }

            public Flux<ByteBuffer> getBody() {
                return Flux.just((Object)ByteBuffer.wrap(body.getBytes(StandardCharsets.UTF_8)));
            }

            public Mono<byte[]> getBodyAsByteArray() {
                return Mono.just((Object)body.getBytes(StandardCharsets.UTF_8));
            }

            public Mono<String> getBodyAsString() {
                return Mono.just((Object)body);
            }

            public Mono<String> getBodyAsString(Charset charset) {
                return this.getBodyAsByteArray().map(body -> new String((byte[])body, charset));
            }
        };
    }

    private static HttpResponse createHttpResponse(final Response<Flux<ByteBuffer>> response) {
        return new HttpResponse(response.getRequest()){

            public int getStatusCode() {
                return response.getStatusCode();
            }

            public String getHeaderValue(String name) {
                return response.getHeaders().getValue(name);
            }

            public HttpHeaders getHeaders() {
                return response.getHeaders();
            }

            public Flux<ByteBuffer> getBody() {
                return (Flux)response.getValue();
            }

            public Mono<byte[]> getBodyAsByteArray() {
                return FluxUtil.collectBytesInByteBufferStream(this.getBody());
            }

            public Mono<String> getBodyAsString() {
                return this.getBodyAsByteArray().map(body -> new String((byte[])body, StandardCharsets.UTF_8));
            }

            public Mono<String> getBodyAsString(Charset charset) {
                return this.getBodyAsByteArray().map(body -> new String((byte[])body, charset));
            }
        };
    }
}

