/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.airlift.slice.SizeOf;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FileStatus {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(FileStatus.class);
    private final String filePath;
    private final long fileSize;

    @JsonCreator
    public FileStatus(@JsonProperty(value="filePath") String filePath, @JsonProperty(value="fileSize") long fileSize) {
        this.filePath = Objects.requireNonNull(filePath, "path is null");
        this.fileSize = fileSize;
    }

    @JsonProperty
    public String getFilePath() {
        return this.filePath;
    }

    @JsonProperty
    public long getFileSize() {
        return this.fileSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileStatus that = (FileStatus)o;
        return this.filePath.equals(that.getFilePath()) && this.fileSize == that.getFileSize();
    }

    public int hashCode() {
        return Objects.hash(this.filePath, this.fileSize);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filePath", (Object)this.filePath).add("fileSize", this.fileSize).toString();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.filePath);
    }
}

