/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem;

import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import java.net.URI;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"exchange.encryption-enabled"})
public class FileSystemExchangeConfig {
    private List<URI> baseDirectories = ImmutableList.of();
    private DataSize maxPageStorageSize = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int exchangeSinkBufferPoolMinSize = 10;
    private int exchangeSinkBuffersPerPartition = 2;
    private DataSize exchangeSinkMaxFileSize = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private int exchangeSourceConcurrentReaders = 4;
    private int exchangeSourceMaxFilesPerReader = 25;
    private int maxOutputPartitionCount = 50;
    private int exchangeFileListingParallelism = 50;
    private DataSize exchangeSourceHandleTargetDataSize = DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.MEGABYTE);

    @NotNull
    @NotEmpty(message="At least one base directory needs to be configured")
    public @NotNull @NotEmpty(message="At least one base directory needs to be configured") List<URI> getBaseDirectories() {
        return this.baseDirectories;
    }

    /*
     * WARNING - void declaration
     */
    @Config(value="exchange.base-directories")
    @LegacyConfig(value={"exchange.base-directory"})
    @ConfigDescription(value="List of base directories separated by commas")
    public FileSystemExchangeConfig setBaseDirectories(String baseDirectories) {
        if (baseDirectories != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String string : baseDirectories.split(",")) {
                void var6_6;
                if (!string.endsWith("/")) {
                    String string2 = string + "/";
                }
                builder.add((Object)URI.create((String)var6_6));
            }
            this.baseDirectories = builder.build();
        }
        return this;
    }

    @NotNull
    public DataSize getMaxPageStorageSize() {
        return this.maxPageStorageSize;
    }

    @Config(value="exchange.max-page-storage-size")
    @ConfigDescription(value="Max storage size of a page written to a sink, including the page itself and its size represented as an int")
    public FileSystemExchangeConfig setMaxPageStorageSize(DataSize maxPageStorageSize) {
        this.maxPageStorageSize = maxPageStorageSize;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getExchangeSinkBufferPoolMinSize() {
        return this.exchangeSinkBufferPoolMinSize;
    }

    @Config(value="exchange.sink-buffer-pool-min-size")
    public FileSystemExchangeConfig setExchangeSinkBufferPoolMinSize(int exchangeSinkBufferPoolMinSize) {
        this.exchangeSinkBufferPoolMinSize = exchangeSinkBufferPoolMinSize;
        return this;
    }

    @Min(value=2L)
    public @Min(value=2L) int getExchangeSinkBuffersPerPartition() {
        return this.exchangeSinkBuffersPerPartition;
    }

    @Config(value="exchange.sink-buffers-per-partition")
    public FileSystemExchangeConfig setExchangeSinkBuffersPerPartition(int exchangeSinkBuffersPerPartition) {
        this.exchangeSinkBuffersPerPartition = exchangeSinkBuffersPerPartition;
        return this;
    }

    @NotNull
    public DataSize getExchangeSinkMaxFileSize() {
        return this.exchangeSinkMaxFileSize;
    }

    @Config(value="exchange.sink-max-file-size")
    @ConfigDescription(value="Max size of files written by exchange sinks")
    public FileSystemExchangeConfig setExchangeSinkMaxFileSize(DataSize exchangeSinkMaxFileSize) {
        this.exchangeSinkMaxFileSize = exchangeSinkMaxFileSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getExchangeSourceConcurrentReaders() {
        return this.exchangeSourceConcurrentReaders;
    }

    @Config(value="exchange.source-concurrent-readers")
    public FileSystemExchangeConfig setExchangeSourceConcurrentReaders(int exchangeSourceConcurrentReaders) {
        this.exchangeSourceConcurrentReaders = exchangeSourceConcurrentReaders;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getExchangeSourceMaxFilesPerReader() {
        return this.exchangeSourceMaxFilesPerReader;
    }

    @Config(value="exchange.source-max-files-per-reader")
    public FileSystemExchangeConfig setExchangeSourceMaxFilesPerReader(int exchangeSourceMaxFilesPerReader) {
        this.exchangeSourceMaxFilesPerReader = exchangeSourceMaxFilesPerReader;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxOutputPartitionCount() {
        return this.maxOutputPartitionCount;
    }

    @Config(value="exchange.max-output-partition-count")
    public FileSystemExchangeConfig setMaxOutputPartitionCount(int maxOutputPartitionCount) {
        this.maxOutputPartitionCount = maxOutputPartitionCount;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getExchangeFileListingParallelism() {
        return this.exchangeFileListingParallelism;
    }

    @Config(value="exchange.file-listing-parallelism")
    @ConfigDescription(value="Max parallelism of file listing calls when enumerating spooling files. The actual parallelism will depend on implementation")
    public FileSystemExchangeConfig setExchangeFileListingParallelism(int exchangeFileListingParallelism) {
        this.exchangeFileListingParallelism = exchangeFileListingParallelism;
        return this;
    }

    @NotNull
    public DataSize getExchangeSourceHandleTargetDataSize() {
        return this.exchangeSourceHandleTargetDataSize;
    }

    @Config(value="exchange.source-handle-target-data-size")
    @ConfigDescription(value="Target size of the data referenced by a single source handle")
    public FileSystemExchangeConfig setExchangeSourceHandleTargetDataSize(DataSize exchangeSourceHandleTargetDataSize) {
        this.exchangeSourceHandleTargetDataSize = exchangeSourceHandleTargetDataSize;
        return this;
    }
}

