/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem.s3;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.utils.FunctionalUtils;

public final class BufferWriteAsyncResponseTransformer<ResponseT>
implements AsyncResponseTransformer<ResponseT, ResponseT> {
    private final byte[] buffer;
    private final int offset;
    private volatile CompletableFuture<Void> cf;
    private volatile ResponseT response;

    public BufferWriteAsyncResponseTransformer(byte[] buffer, int offset) {
        Preconditions.checkArgument((offset < buffer.length ? 1 : 0) != 0, (Object)"Buffer offset should be smaller than buffer length");
        this.buffer = Objects.requireNonNull(buffer, "buffer is null");
        this.offset = offset;
    }

    public CompletableFuture<ResponseT> prepare() {
        this.cf = new CompletableFuture();
        return this.cf.thenApply(ignored -> this.response);
    }

    public void onResponse(ResponseT response) {
        this.response = response;
    }

    public void onStream(SdkPublisher<ByteBuffer> publisher) {
        publisher.subscribe((Subscriber)new BufferSubscriber(this.buffer, this.offset, this.cf));
    }

    public void exceptionOccurred(Throwable throwable) {
        this.cf.completeExceptionally(throwable);
    }

    static <ResponseT> AsyncResponseTransformer<ResponseT, ResponseT> toBufferWrite(byte[] buffer, int offset) {
        return new BufferWriteAsyncResponseTransformer<ResponseT>(buffer, offset);
    }

    static class BufferSubscriber
    implements Subscriber<ByteBuffer> {
        private int offset;
        private final byte[] buffer;
        private final CompletableFuture<Void> future;
        private Subscription subscription;

        BufferSubscriber(byte[] buffer, int offset, CompletableFuture<Void> future) {
            this.offset = offset;
            this.buffer = Objects.requireNonNull(buffer, "buffer is null");
            this.future = Objects.requireNonNull(future, "future is null");
        }

        public void onSubscribe(Subscription s) {
            if (this.subscription != null) {
                s.cancel();
                return;
            }
            this.subscription = s;
            this.subscription.request(Long.MAX_VALUE);
        }

        public void onNext(ByteBuffer byteBuffer) {
            FunctionalUtils.invokeSafely(() -> {
                int readableBytes = byteBuffer.remaining();
                if (byteBuffer.hasArray()) {
                    System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), this.buffer, this.offset, readableBytes);
                } else {
                    byteBuffer.asReadOnlyBuffer().get(this.buffer, this.offset, readableBytes);
                }
                this.offset += readableBytes;
            });
            this.subscription.request(1L);
        }

        public void onError(Throwable throwable) {
            this.future.completeExceptionally(throwable);
        }

        public void onComplete() {
            this.future.complete(null);
        }
    }
}

