/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem.s3;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.model.StorageClass;

public class ExchangeS3Config {
    private String s3AwsAccessKey;
    private String s3AwsSecretKey;
    private Optional<String> s3IamRole = Optional.empty();
    private Optional<String> s3ExternalId = Optional.empty();
    private Optional<Region> s3Region = Optional.empty();
    private Optional<String> s3Endpoint = Optional.empty();
    private int s3MaxErrorRetries = 10;
    private DataSize s3UploadPartSize = DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private StorageClass storageClass = StorageClass.STANDARD;
    private RetryMode retryMode = RetryMode.ADAPTIVE;
    private int asyncClientConcurrency = 100;
    private int asyncClientMaxPendingConnectionAcquires = 10000;
    private Duration connectionAcquisitionTimeout = new Duration(1.0, TimeUnit.MINUTES);
    private boolean s3PathStyleAccess;
    private Optional<String> gcsJsonKeyFilePath = Optional.empty();
    private Optional<String> gcsJsonKey = Optional.empty();

    public String getS3AwsAccessKey() {
        return this.s3AwsAccessKey;
    }

    @Config(value="exchange.s3.aws-access-key")
    public ExchangeS3Config setS3AwsAccessKey(String s3AwsAccessKey) {
        this.s3AwsAccessKey = s3AwsAccessKey;
        return this;
    }

    public String getS3AwsSecretKey() {
        return this.s3AwsSecretKey;
    }

    @Config(value="exchange.s3.aws-secret-key")
    @ConfigSecuritySensitive
    public ExchangeS3Config setS3AwsSecretKey(String s3AwsSecretKey) {
        this.s3AwsSecretKey = s3AwsSecretKey;
        return this;
    }

    public Optional<String> getS3IamRole() {
        return this.s3IamRole;
    }

    @Config(value="exchange.s3.iam-role")
    @ConfigDescription(value="ARN of an IAM role to assume when connecting to S3")
    public ExchangeS3Config setS3IamRole(String s3IamRole) {
        this.s3IamRole = Optional.ofNullable(s3IamRole);
        return this;
    }

    public Optional<String> getS3ExternalId() {
        return this.s3ExternalId;
    }

    @Config(value="exchange.s3.external-id")
    @ConfigDescription(value="External ID for the IAM role trust policy when connecting to S3")
    public ExchangeS3Config setS3ExternalId(String s3ExternalId) {
        this.s3ExternalId = Optional.ofNullable(s3ExternalId);
        return this;
    }

    public Optional<Region> getS3Region() {
        return this.s3Region;
    }

    @Config(value="exchange.s3.region")
    public ExchangeS3Config setS3Region(String s3Region) {
        if (s3Region != null) {
            this.s3Region = Optional.of(Region.of((String)s3Region.toLowerCase(Locale.ENGLISH)));
        }
        return this;
    }

    public Optional<String> getS3Endpoint() {
        return this.s3Endpoint;
    }

    @Config(value="exchange.s3.endpoint")
    public ExchangeS3Config setS3Endpoint(String s3Endpoint) {
        this.s3Endpoint = Optional.ofNullable(s3Endpoint);
        return this;
    }

    @AssertTrue(message="Either exchange.s3.region or exchange.s3.endpoint is expected to be set")
    public @AssertTrue(message="Either exchange.s3.region or exchange.s3.endpoint is expected to be set") boolean isEndpointOrRegionSet() {
        return this.s3Region.isPresent() || this.s3Endpoint.isPresent();
    }

    @Min(value=0L)
    public @Min(value=0L) int getS3MaxErrorRetries() {
        return this.s3MaxErrorRetries;
    }

    @Config(value="exchange.s3.max-error-retries")
    public ExchangeS3Config setS3MaxErrorRetries(int s3MaxErrorRetries) {
        this.s3MaxErrorRetries = s3MaxErrorRetries;
        return this;
    }

    @NotNull
    @MinDataSize(value="5MB")
    @MaxDataSize(value="256MB")
    public @NotNull @MinDataSize(value="5MB") @MaxDataSize(value="256MB") DataSize getS3UploadPartSize() {
        return this.s3UploadPartSize;
    }

    @Config(value="exchange.s3.upload.part-size")
    @ConfigDescription(value="Part size for S3 multi-part upload")
    public ExchangeS3Config setS3UploadPartSize(DataSize s3UploadPartSize) {
        this.s3UploadPartSize = s3UploadPartSize;
        return this;
    }

    @NotNull
    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    @Config(value="exchange.s3.storage-class")
    public ExchangeS3Config setStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass;
        return this;
    }

    @NotNull
    public RetryMode getRetryMode() {
        return this.retryMode;
    }

    @Config(value="exchange.s3.retry-mode")
    public ExchangeS3Config setRetryMode(RetryMode retryMode) {
        this.retryMode = retryMode;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getAsyncClientConcurrency() {
        return this.asyncClientConcurrency;
    }

    @Config(value="exchange.s3.async-client-concurrency")
    public ExchangeS3Config setAsyncClientConcurrency(int asyncClientConcurrency) {
        this.asyncClientConcurrency = asyncClientConcurrency;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getAsyncClientMaxPendingConnectionAcquires() {
        return this.asyncClientMaxPendingConnectionAcquires;
    }

    @Config(value="exchange.s3.async-client-max-pending-connection-acquires")
    public ExchangeS3Config setAsyncClientMaxPendingConnectionAcquires(int asyncClientMaxPendingConnectionAcquires) {
        this.asyncClientMaxPendingConnectionAcquires = asyncClientMaxPendingConnectionAcquires;
        return this;
    }

    public Duration getConnectionAcquisitionTimeout() {
        return this.connectionAcquisitionTimeout;
    }

    @Config(value="exchange.s3.async-client-connection-acquisition-timeout")
    public ExchangeS3Config setConnectionAcquisitionTimeout(Duration connectionAcquisitionTimeout) {
        this.connectionAcquisitionTimeout = connectionAcquisitionTimeout;
        return this;
    }

    public boolean isS3PathStyleAccess() {
        return this.s3PathStyleAccess;
    }

    @Config(value="exchange.s3.path-style-access")
    @ConfigDescription(value="Use path-style access for all request to S3")
    public ExchangeS3Config setS3PathStyleAccess(boolean s3PathStyleAccess) {
        this.s3PathStyleAccess = s3PathStyleAccess;
        return this;
    }

    public Optional<@FileExists String> getGcsJsonKeyFilePath() {
        return this.gcsJsonKeyFilePath;
    }

    @Config(value="exchange.gcs.json-key-file-path")
    @ConfigDescription(value="Path to the JSON file that contains your Google Cloud Platform service account key. Not to be set together with `exchange.gcs.json-key`")
    public ExchangeS3Config setGcsJsonKeyFilePath(String gcsJsonKeyFilePath) {
        this.gcsJsonKeyFilePath = Optional.ofNullable(gcsJsonKeyFilePath);
        return this;
    }

    public Optional<String> getGcsJsonKey() {
        return this.gcsJsonKey;
    }

    @Config(value="exchange.gcs.json-key")
    @ConfigDescription(value="Your Google Cloud Platform service account key in JSON format. Not to be set together with `exchange.gcs.json-key-file-path`")
    @ConfigSecuritySensitive
    public ExchangeS3Config setGcsJsonKey(String gcsJsonKey) {
        this.gcsJsonKey = Optional.ofNullable(gcsJsonKey);
        return this;
    }
}

