/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.mapping;

import io.airlift.configuration.Config;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class MappingConfig {
    public static final String CASE_INSENSITIVE_NAME_MATCHING = "case-insensitive-name-matching";
    private boolean caseInsensitiveNameMatching;
    private Duration caseInsensitiveNameMatchingCacheTtl = new Duration(1.0, TimeUnit.MINUTES);
    private String configFile;
    private Duration refreshPeriod;

    public boolean isCaseInsensitiveNameMatching() {
        return this.caseInsensitiveNameMatching;
    }

    @Config(value="case-insensitive-name-matching")
    public MappingConfig setCaseInsensitiveNameMatching(boolean caseInsensitiveNameMatching) {
        this.caseInsensitiveNameMatching = caseInsensitiveNameMatching;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getCaseInsensitiveNameMatchingCacheTtl() {
        return this.caseInsensitiveNameMatchingCacheTtl;
    }

    @Config(value="case-insensitive-name-matching.cache-ttl")
    public MappingConfig setCaseInsensitiveNameMatchingCacheTtl(Duration caseInsensitiveNameMatchingCacheTtl) {
        this.caseInsensitiveNameMatchingCacheTtl = caseInsensitiveNameMatchingCacheTtl;
        return this;
    }

    public Optional<@FileExists String> getCaseInsensitiveNameMatchingConfigFile() {
        return Optional.ofNullable(this.configFile);
    }

    @Config(value="case-insensitive-name-matching.config-file")
    public MappingConfig setCaseInsensitiveNameMatchingConfigFile(String authToLocalConfigFile) {
        this.configFile = authToLocalConfigFile;
        return this;
    }

    public Optional<@MinDuration(value="1ms") Duration> getCaseInsensitiveNameMatchingConfigFileRefreshPeriod() {
        return Optional.ofNullable(this.refreshPeriod);
    }

    @Config(value="case-insensitive-name-matching.config-file.refresh-period")
    public MappingConfig setCaseInsensitiveNameMatchingConfigFileRefreshPeriod(Duration refreshPeriod) {
        this.refreshPeriod = refreshPeriod;
        return this;
    }
}

