/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.plugin.base.jmx.PrefixObjectNameGeneratorModule;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeManager;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeModule;
import io.trino.spi.exchange.ExchangeManager;
import io.trino.spi.exchange.ExchangeManagerContext;
import io.trino.spi.exchange.ExchangeManagerFactory;
import java.util.Map;
import java.util.Objects;
import org.weakref.jmx.guice.MBeanModule;

public class FileSystemExchangeManagerFactory
implements ExchangeManagerFactory {
    static final String FILESYSTEM = "filesystem";

    public String getName() {
        return FILESYSTEM;
    }

    public ExchangeManager create(Map<String, String> config, ExchangeManagerContext context) {
        Objects.requireNonNull(config, "config is null");
        Bootstrap app = new Bootstrap(new Module[]{new MBeanModule(), new MBeanServerModule(), new PrefixObjectNameGeneratorModule("io.trino.plugin.exchange.filesystem", "trino.plugin.exchange.filesystem"), new FileSystemExchangeModule(), binder -> {
            binder.bind(OpenTelemetry.class).toInstance((Object)context.getOpenTelemetry());
            binder.bind(Tracer.class).toInstance((Object)context.getTracer());
        }});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (ExchangeManager)injector.getInstance(FileSystemExchangeManager.class);
    }
}

