/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.stats.TimeStat;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class ExecutionStats {
    private final TimeStat finished = new TimeStat(TimeUnit.MILLISECONDS);
    private final TimeStat failed = new TimeStat(TimeUnit.MILLISECONDS);

    public <T> T record(Supplier<T> call) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            T result = call.get();
            this.finished.add((double)stopwatch.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            return result;
        }
        catch (Throwable t) {
            this.failed.add((double)stopwatch.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            throw t;
        }
    }

    public <T> CompletableFuture<T> record(CompletableFuture<T> future) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        future.whenComplete((value, failure) -> {
            if (failure == null) {
                this.finished.add((double)stopwatch.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            } else {
                this.failed.add((double)stopwatch.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            }
        });
        return future;
    }

    public <T> ListenableFuture<T> record(ListenableFuture<T> future) {
        final Stopwatch stopwatch = Stopwatch.createStarted();
        Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){
            final /* synthetic */ ExecutionStats this$0;
            {
                this.this$0 = this$0;
            }

            public void onSuccess(T result) {
                this.this$0.finished.add((double)stopwatch.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            }

            public void onFailure(Throwable t) {
                this.this$0.failed.add((double)stopwatch.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return future;
    }

    @Managed
    @Nested
    public TimeStat getFinished() {
        return this.finished;
    }

    @Managed
    @Nested
    public TimeStat getFailed() {
        return this.failed;
    }
}

