/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem.containers;

import com.google.common.collect.ImmutableMap;
import io.trino.testing.containers.BaseTestContainer;
import io.trino.testing.containers.KeyManagementServer;
import io.trino.testing.containers.Minio;
import io.trino.testing.containers.TestContainers;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.testcontainers.containers.Network;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;

public class MinioStorage
implements AutoCloseable {
    public static final String ACCESS_KEY = "accesskey";
    public static final String SECRET_KEY = "secretkey";
    public static final String KMS_KEY_ID = "kms_key_id";
    private final String bucketName;
    private final Network network;
    private final Minio minio;
    private final Optional<KeyManagementServer> kms;

    public MinioStorage(String bucketName) {
        this(bucketName, false);
    }

    public MinioStorage(String bucketName, boolean withKms) {
        this.bucketName = Objects.requireNonNull(bucketName, "bucketName is null");
        this.network = Network.newNetwork();
        this.kms = withKms ? Optional.of(((KeyManagementServer.Builder)KeyManagementServer.builder().withNetwork(this.network)).build()) : Optional.empty();
        this.minio = this.buildMinio(this.kms);
    }

    private Minio buildMinio(Optional<KeyManagementServer> kms) {
        Minio.Builder minioBuilder = (Minio.Builder)((Minio.Builder)Minio.builder().withNetwork(this.network)).withEnvVars((Map)ImmutableMap.builder().put((Object)"MINIO_ACCESS_KEY", (Object)ACCESS_KEY).put((Object)"MINIO_SECRET_KEY", (Object)SECRET_KEY).buildOrThrow());
        kms.ifPresent(aKms -> ((Minio.Builder)minioBuilder.withEnvVars((Map)ImmutableMap.builder().put((Object)"MINIO_ACCESS_KEY", (Object)ACCESS_KEY).put((Object)"MINIO_SECRET_KEY", (Object)SECRET_KEY).put((Object)"MINIO_KMS_KES_ENDPOINT", (Object)aKms.getMinioKesEndpointURL()).put((Object)"MINIO_KMS_KES_CERT_FILE", (Object)"/kms_client.crt").put((Object)"MINIO_KMS_KES_KEY_FILE", (Object)"/kms_client.key").put((Object)"MINIO_KMS_KES_KEY_NAME", (Object)KMS_KEY_ID).put((Object)"MINIO_KMS_KES_CAPATH", (Object)"/kms.crt").put((Object)"MINIO_KMS_KES_CA_PATH", (Object)"/kms.crt").buildOrThrow())).withFilesToMount(Map.of("/kms_client.key", TestContainers.getPathFromClassPathResource((String)"minio/kms_client.key"), "/kms_client.crt", TestContainers.getPathFromClassPathResource((String)"minio/kms_client.crt"), "/kms.crt", TestContainers.getPathFromClassPathResource((String)"kms/kms.crt"))));
        return minioBuilder.build();
    }

    public void start() {
        this.kms.ifPresent(KeyManagementServer::start);
        this.minio.start();
        S3Client s3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().endpointOverride(URI.create("http://localhost:" + this.minio.getMinioApiEndpoint().getPort()))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)ACCESS_KEY, (String)SECRET_KEY)))).region(Region.US_EAST_1)).forcePathStyle(Boolean.valueOf(true))).build();
        CreateBucketRequest createBucketRequest = (CreateBucketRequest)CreateBucketRequest.builder().bucket(this.bucketName).build();
        s3Client.createBucket(createBucketRequest);
    }

    public Minio getMinio() {
        return this.minio;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public void close() throws Exception {
        this.network.close();
        this.minio.close();
        this.kms.ifPresent(BaseTestContainer::close);
    }

    public static Map<String, String> getExchangeManagerProperties(MinioStorage minioStorage) {
        return ImmutableMap.builder().put((Object)"exchange.base-directories", (Object)("s3://" + minioStorage.getBucketName())).put((Object)"exchange.sink-max-file-size", (Object)"16MB").put((Object)"exchange.s3.aws-access-key", (Object)ACCESS_KEY).put((Object)"exchange.s3.aws-secret-key", (Object)SECRET_KEY).put((Object)"exchange.s3.region", (Object)"us-east-1").put((Object)"exchange.s3.path-style-access", (Object)"true").put((Object)"exchange.s3.endpoint", (Object)("http://" + String.valueOf(minioStorage.getMinio().getMinioApiEndpoint()))).put((Object)"exchange.source-handle-target-data-size", (Object)"1MB").buildOrThrow();
    }

    public static Map<String, String> getExchangeManagerPropertiesWithKms(MinioStorage minioStorage) {
        return ImmutableMap.builder().putAll(MinioStorage.getExchangeManagerProperties(minioStorage)).put((Object)"exchange.s3.sse.type", (Object)"KMS").put((Object)"exchange.s3.sse.kms-key-id", (Object)KMS_KEY_ID).buildOrThrow();
    }

    public static Map<String, String> getExchangeManagerPropertiesWithSseS3(MinioStorage minioStorage) {
        return ImmutableMap.builder().putAll(MinioStorage.getExchangeManagerProperties(minioStorage)).put((Object)"exchange.s3.sse.type", (Object)"S3").buildOrThrow();
    }
}

