/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeConfig;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestFileSystemExchangeConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((FileSystemExchangeConfig)ConfigAssertions.recordDefaults(FileSystemExchangeConfig.class)).setBaseDirectories(null).setMaxPageStorageSize(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setExchangeSinkBufferPoolMinSize(10).setExchangeSinkBuffersPerPartition(2).setExchangeSinkMaxFileSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setExchangeSourceConcurrentReaders(4).setExchangeSourceMaxFilesPerReader(25).setMaxOutputPartitionCount(50).setExchangeFileListingParallelism(50).setExchangeSourceHandleTargetDataSize(DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"exchange.base-directories", (Object)"s3://exchange-spooling-test/").put((Object)"exchange.max-page-storage-size", (Object)"32MB").put((Object)"exchange.sink-buffer-pool-min-size", (Object)"20").put((Object)"exchange.sink-buffers-per-partition", (Object)"3").put((Object)"exchange.sink-max-file-size", (Object)"2GB").put((Object)"exchange.source-concurrent-readers", (Object)"10").put((Object)"exchange.source-max-files-per-reader", (Object)"111").put((Object)"exchange.max-output-partition-count", (Object)"53").put((Object)"exchange.file-listing-parallelism", (Object)"20").put((Object)"exchange.source-handle-target-data-size", (Object)"1GB").buildOrThrow();
        FileSystemExchangeConfig expected = new FileSystemExchangeConfig().setBaseDirectories("s3://exchange-spooling-test/").setMaxPageStorageSize(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setExchangeSinkBufferPoolMinSize(20).setExchangeSinkBuffersPerPartition(3).setExchangeSinkMaxFileSize(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setExchangeSourceConcurrentReaders(10).setExchangeSourceMaxFilesPerReader(111).setMaxOutputPartitionCount(53).setExchangeFileListingParallelism(20).setExchangeSourceHandleTargetDataSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

