/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem;

import io.trino.plugin.exchange.filesystem.FileSystemExchangeSource;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeStats;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeStorage;
import io.trino.plugin.exchange.filesystem.local.LocalFileSystemExchangeStorage;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.CompletableFutureAssert;
import org.junit.jupiter.api.Test;

public class TestFileSystemExchangeSource {
    @Test
    public void testIsBlockedNonCancellable() {
        try (FileSystemExchangeSource source = new FileSystemExchangeSource((FileSystemExchangeStorage)new LocalFileSystemExchangeStorage(), new FileSystemExchangeStats(), 1024, 2, 1);){
            CompletableFuture first = source.isBlocked();
            CompletableFuture second = source.isBlocked();
            ((CompletableFutureAssert)Assertions.assertThat((CompletableFuture)first).isNotDone()).isNotCancelled();
            ((CompletableFutureAssert)Assertions.assertThat((CompletableFuture)second).isNotDone()).isNotCancelled();
            first.cancel(true);
            ((CompletableFutureAssert)Assertions.assertThat((CompletableFuture)first).isDone()).isCancelled();
            ((CompletableFutureAssert)Assertions.assertThat((CompletableFuture)second).isNotDone()).isNotCancelled();
            CompletableFuture third = source.isBlocked();
            ((CompletableFutureAssert)Assertions.assertThat((CompletableFuture)third).isNotDone()).isNotCancelled();
        }
    }
}

