/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem.azure;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.trino.plugin.exchange.filesystem.azure.ExchangeAzureConfig;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestExchangeAzureConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((ExchangeAzureConfig)ConfigAssertions.recordDefaults(ExchangeAzureConfig.class)).setAzureStorageEndpoint(null).setAzureStorageConnectionString(null).setAzureStorageBlockSize(DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxErrorRetries(10));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"exchange.azure.connection-string", (Object)"connection").put((Object)"exchange.azure.endpoint", (Object)"endpoint").put((Object)"exchange.azure.block-size", (Object)"8MB").put((Object)"exchange.azure.max-error-retries", (Object)"8").buildOrThrow();
        ExchangeAzureConfig expected = new ExchangeAzureConfig().setAzureStorageConnectionString("connection").setAzureStorageEndpoint("endpoint").setAzureStorageBlockSize(DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxErrorRetries(8);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

