/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem.s3;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.testing.ValidationAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.plugin.exchange.filesystem.s3.ExchangeS3Config;
import jakarta.validation.constraints.AssertTrue;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.services.s3.model.StorageClass;

public class TestExchangeS3Config {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((ExchangeS3Config)ConfigAssertions.recordDefaults(ExchangeS3Config.class)).setS3AwsAccessKey(null).setS3AwsSecretKey(null).setS3IamRole(null).setS3ExternalId(null).setS3Region(null).setS3Endpoint(null).setS3MaxErrorRetries(10).setS3UploadPartSize(DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setStorageClass(StorageClass.STANDARD).setRetryMode(RetryMode.ADAPTIVE_V2).setAsyncClientConcurrency(100).setAsyncClientMaxPendingConnectionAcquires(10000).setConnectionAcquisitionTimeout(new Duration(1.0, TimeUnit.MINUTES)).setS3PathStyleAccess(false).setSseType(ExchangeS3Config.S3SseType.NONE).setSseKmsKeyId(null).setGcsJsonKeyFilePath(null).setGcsJsonKey(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path jsonKeyFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"exchange.s3.aws-access-key", (Object)"access").put((Object)"exchange.s3.aws-secret-key", (Object)"secret").put((Object)"exchange.s3.iam-role", (Object)"roleArn").put((Object)"exchange.s3.external-id", (Object)"externalId").put((Object)"exchange.s3.region", (Object)"us-west-1").put((Object)"exchange.s3.endpoint", (Object)"https://s3.us-east-1.amazonaws.com").put((Object)"exchange.s3.max-error-retries", (Object)"8").put((Object)"exchange.s3.upload.part-size", (Object)"10MB").put((Object)"exchange.s3.storage-class", (Object)"REDUCED_REDUNDANCY").put((Object)"exchange.s3.retry-mode", (Object)"STANDARD").put((Object)"exchange.s3.async-client-concurrency", (Object)"202").put((Object)"exchange.s3.async-client-max-pending-connection-acquires", (Object)"999").put((Object)"exchange.s3.async-client-connection-acquisition-timeout", (Object)"5m").put((Object)"exchange.s3.path-style-access", (Object)"true").put((Object)"exchange.s3.sse.type", (Object)"KMS").put((Object)"exchange.s3.sse.kms-key-id", (Object)"kms_key_id").put((Object)"exchange.gcs.json-key-file-path", (Object)jsonKeyFile.toString()).put((Object)"exchange.gcs.json-key", (Object)"{}").buildOrThrow();
        ExchangeS3Config expected = new ExchangeS3Config().setS3AwsAccessKey("access").setS3AwsSecretKey("secret").setS3IamRole("roleArn").setS3ExternalId("externalId").setS3Region("us-west-1").setS3Endpoint("https://s3.us-east-1.amazonaws.com").setS3MaxErrorRetries(8).setS3UploadPartSize(DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setStorageClass(StorageClass.REDUCED_REDUNDANCY).setRetryMode(RetryMode.STANDARD).setAsyncClientConcurrency(202).setAsyncClientMaxPendingConnectionAcquires(999).setConnectionAcquisitionTimeout(new Duration(5.0, TimeUnit.MINUTES)).setS3PathStyleAccess(true).setSseType(ExchangeS3Config.S3SseType.KMS).setSseKmsKeyId("kms_key_id").setS3PathStyleAccess(true).setGcsJsonKeyFilePath(jsonKeyFile.toString()).setGcsJsonKey("{}");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testSseConfigValidation() {
        ValidationAssertions.assertFailsValidation((Object)new ExchangeS3Config().setSseType(ExchangeS3Config.S3SseType.KMS), (String)"sseConfigValid", (String)"Property value of exchange.s3.sse.kms-key-id needs to be provided only when exchange.s3.sse.type=KMS", AssertTrue.class);
        ValidationAssertions.assertFailsValidation((Object)new ExchangeS3Config().setSseType(ExchangeS3Config.S3SseType.NONE).setSseKmsKeyId("keyId"), (String)"sseConfigValid", (String)"Property value of exchange.s3.sse.kms-key-id needs to be provided only when exchange.s3.sse.type=KMS", AssertTrue.class);
        ValidationAssertions.assertFailsValidation((Object)new ExchangeS3Config().setSseType(ExchangeS3Config.S3SseType.S3).setSseKmsKeyId("keyId"), (String)"sseConfigValid", (String)"Property value of exchange.s3.sse.kms-key-id needs to be provided only when exchange.s3.sse.type=KMS", AssertTrue.class);
    }
}

