/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.base.CaseFormat;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.Message;
import com.google.inject.spi.ProviderInstanceBinding;
import io.airlift.configuration.ConfigBinder;
import io.airlift.configuration.ConfigDefaults;
import io.airlift.configuration.ConfigDefaultsHolder;
import io.airlift.configuration.ConfigPropertyMetadata;
import io.airlift.configuration.ConfigurationAwareModule;
import io.airlift.configuration.ConfigurationBinding;
import io.airlift.configuration.ConfigurationBindingListener;
import io.airlift.configuration.ConfigurationBindingListenerHolder;
import io.airlift.configuration.ConfigurationMetadata;
import io.airlift.configuration.ConfigurationProvider;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.GlobalDefaults;
import io.airlift.configuration.InvalidConfigurationException;
import io.airlift.configuration.Problems;
import io.airlift.configuration.WarningsMonitor;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class ConfigurationFactory {
    @GuardedBy(value="VALIDATOR")
    private static final Validator VALIDATOR;
    private static final Splitter VALUE_SPLITTER;
    private static final LoadingCache<Class<?>, ConfigurationMetadata<?>> METADATA_CACHE;
    private final Map<String, String> properties;
    private final WarningsMonitor warningsMonitor;
    private final ConcurrentMap<ConfigurationProvider<?>, Object> instanceCache = new ConcurrentHashMap();
    private final Set<ConfigPropertyMetadata> usedProperties = Sets.newConcurrentHashSet();
    private final Set<String> allSeenProperties = new HashSet<String>();
    private final Set<ConfigurationProvider<?>> registeredProviders = Sets.newConcurrentHashSet();
    @GuardedBy(value="this")
    private final List<Consumer<ConfigurationProvider<?>>> configurationBindingListeners = new ArrayList();
    private final ListMultimap<Key<?>, ConfigDefaultsHolder<?>> registeredDefaultConfigs = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());

    public ConfigurationFactory(Map<String, String> properties) {
        this(properties, null);
    }

    public ConfigurationFactory(Map<String, String> properties, WarningsMonitor warningsMonitor) {
        this.properties = ImmutableMap.copyOf(properties);
        this.warningsMonitor = warningsMonitor;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void consumeProperty(ConfigPropertyMetadata property) {
        Objects.requireNonNull(property, "property is null");
        this.usedProperties.add(property);
    }

    public Set<ConfigPropertyMetadata> getUsedProperties() {
        return ImmutableSortedSet.copyOf(this.usedProperties);
    }

    public Collection<Message> registerConfigurationClasses(Module module) {
        return this.registerConfigurationClasses((Collection<? extends Module>)ImmutableList.of((Object)module));
    }

    public Set<String> getAllSeenProperties() {
        return this.allSeenProperties;
    }

    public Collection<Message> registerConfigurationClasses(Collection<? extends Module> modules) {
        modules.stream().filter(ConfigurationAwareModule.class::isInstance).map(ConfigurationAwareModule.class::cast).forEach(module -> module.setConfigurationFactory(this));
        final ArrayList<Message> errors = new ArrayList<Message>();
        for (Element element : Elements.getElements(modules)) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(this){
                final /* synthetic */ ConfigurationFactory this$0;
                {
                    this.this$0 = this$0;
                }

                public <T> Void visit(Binding<T> binding) {
                    ProviderInstanceBinding providerInstanceBinding;
                    Provider provider;
                    if (binding instanceof InstanceBinding) {
                        InstanceBinding instanceBinding = (InstanceBinding)binding;
                        if (instanceBinding.getInstance() instanceof ConfigurationBindingListenerHolder) {
                            this.this$0.addConfigurationBindingListener(((ConfigurationBindingListenerHolder)instanceBinding.getInstance()).getConfigurationBindingListener());
                        }
                        if (instanceBinding.getInstance() instanceof ConfigDefaultsHolder) {
                            this.this$0.registerConfigDefaults((ConfigDefaultsHolder)instanceBinding.getInstance());
                        }
                    }
                    if (binding instanceof ProviderInstanceBinding && (provider = (providerInstanceBinding = (ProviderInstanceBinding)binding).getProviderInstance()) instanceof ConfigurationProvider) {
                        this.this$0.registerConfigurationProvider((ConfigurationProvider)provider, Optional.of(binding.getSource()));
                    }
                    return null;
                }

                public Void visit(Message error) {
                    errors.add(error);
                    return null;
                }
            });
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerConfigurationProvider(ConfigurationProvider<?> configurationProvider, Optional<Object> bindingSource) {
        configurationProvider.setConfigurationFactory(this);
        configurationProvider.setBindingSource(bindingSource);
        ImmutableList listeners = ImmutableList.of();
        ConfigurationFactory configurationFactory = this;
        synchronized (configurationFactory) {
            if (this.registeredProviders.add(configurationProvider)) {
                listeners = ImmutableList.copyOf(this.configurationBindingListeners);
            }
        }
        listeners.forEach(listener -> listener.accept(configurationProvider));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurationBindingListener(ConfigurationBindingListener listener) {
        ImmutableSet currentProviders;
        ConfigurationProviderConsumer consumer = new ConfigurationProviderConsumer(this, listener);
        ConfigurationFactory configurationFactory = this;
        synchronized (configurationFactory) {
            this.configurationBindingListeners.add(consumer);
            currentProviders = ImmutableSet.copyOf(this.registeredProviders);
        }
        currentProviders.forEach((Consumer)consumer);
    }

    public List<Message> validateRegisteredConfigurationProvider() {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (ConfigurationProvider configurationProvider : ImmutableList.copyOf(this.registeredProviders)) {
            try {
                configurationProvider.get();
            }
            catch (ConfigurationException e) {
                ImmutableList sources = configurationProvider.getBindingSource().map(ImmutableList::of).orElse(ImmutableList.of());
                for (Message message : e.getErrorMessages()) {
                    messages.add(new Message((List)sources, message.getMessage(), message.getCause()));
                }
            }
        }
        return messages;
    }

    Iterable<ConfigurationProvider<?>> getConfigurationProviders() {
        return ImmutableList.copyOf(this.registeredProviders);
    }

    <T> void registerConfigDefaults(ConfigDefaultsHolder<T> holder) {
        this.registeredDefaultConfigs.put(holder.getConfigKey(), holder);
    }

    private <T> ConfigDefaults<T> getConfigDefaults(Key<T> key) {
        ImmutableList.Builder defaults = ImmutableList.builder();
        Key globalDefaults = Key.get((TypeLiteral)key.getTypeLiteral(), GlobalDefaults.class);
        this.registeredDefaultConfigs.get((Object)globalDefaults).stream().map(ConfigurationFactory.castHolder()).sorted().map(ConfigDefaultsHolder::getConfigDefaults).forEach(arg_0 -> ((ImmutableList.Builder)defaults).add(arg_0));
        this.registeredDefaultConfigs.get(key).stream().map(ConfigurationFactory.castHolder()).sorted().map(ConfigDefaultsHolder::getConfigDefaults).forEach(arg_0 -> ((ImmutableList.Builder)defaults).add(arg_0));
        return ConfigDefaults.configDefaults(defaults.build());
    }

    private static <T> Function<ConfigDefaultsHolder<?>, ConfigDefaultsHolder<T>> castHolder() {
        return holder -> holder;
    }

    <T> T getDefaultConfig(Key<T> key) {
        ConfigurationMetadata<T> configurationMetadata = this.getMetadata(key);
        configurationMetadata.getProblems().throwIfHasErrors();
        T instance = ConfigurationFactory.newInstance(configurationMetadata);
        ConfigDefaults<T> configDefaults = this.getConfigDefaults(key);
        configDefaults.setDefaults(instance);
        return instance;
    }

    public <T> T build(Class<T> configClass) {
        return this.build(configClass, null);
    }

    public <T> T build(Class<T> configClass, @Nullable String prefix) {
        return this.build(configClass, Optional.ofNullable(prefix), ConfigDefaults.noDefaults()).getInstance();
    }

    <T> T build(ConfigurationProvider<T> configurationProvider) {
        T existingValue;
        Objects.requireNonNull(configurationProvider, "configurationProvider");
        this.registerConfigurationProvider(configurationProvider, Optional.empty());
        T instance = this.getCachedInstance(configurationProvider);
        if (instance != null) {
            return instance;
        }
        ConfigurationBinding<T> configurationBinding = configurationProvider.getConfigurationBinding();
        ConfigurationHolder<T> holder = this.build(configurationBinding.getConfigClass(), configurationBinding.getPrefix(), this.getConfigDefaults(configurationBinding.getKey()));
        instance = holder.getInstance();
        if (this.warningsMonitor != null) {
            for (Message message : holder.getProblems().getWarnings()) {
                this.warningsMonitor.onWarning(message.toString());
            }
        }
        if ((existingValue = this.putCachedInstance(configurationProvider, instance)) != null) {
            return existingValue;
        }
        return instance;
    }

    private <T> T getCachedInstance(ConfigurationProvider<T> configurationProvider) {
        return (T)this.instanceCache.get(configurationProvider);
    }

    private <T> T putCachedInstance(ConfigurationProvider<T> configurationProvider, T instance) {
        return (T)this.instanceCache.putIfAbsent(configurationProvider, instance);
    }

    private <T> ConfigurationHolder<T> build(Class<T> configClass, Optional<String> configPrefix, ConfigDefaults<T> configDefaults) {
        if (configClass == null) {
            throw new NullPointerException("configClass is null");
        }
        String prefix = configPrefix.map(value -> value + ".").orElse("");
        Problems problems = new Problems();
        ConfigurationMetadata<T> configurationMetadata = this.getMetadata(configClass);
        problems.record(configurationMetadata.getProblems());
        problems.throwIfHasErrors();
        T instance = ConfigurationFactory.newInstance(configurationMetadata);
        configDefaults.setDefaults(instance);
        for (ConfigurationMetadata.AttributeMetadata attributeMetadata : configurationMetadata.getAttributes().values()) {
            this.allSeenProperties.add(prefix + attributeMetadata.getInjectionPoint().getProperty());
            Problems attributeProblems = new Problems();
            try {
                this.setConfigProperty(instance, attributeMetadata, prefix, attributeProblems);
            }
            catch (InvalidConfigurationException e) {
                attributeProblems.addError(e.getCause(), e.getMessage(), new Object[0]);
            }
            problems.record(attributeProblems);
        }
        if (configClass.isAnnotationPresent(DefunctConfig.class)) {
            for (String value2 : configClass.getAnnotation(DefunctConfig.class).value()) {
                String name = prefix + (String)value2;
                if (value2.isEmpty() || this.properties.get(name) == null) continue;
                problems.addError("Defunct property '%s' (class [%s]) cannot be configured.", name, configClass.toString());
            }
        }
        problems.throwIfHasErrors();
        for (ConstraintViolation constraintViolation : ConfigurationFactory.validate(instance)) {
            String propertyFieldName = constraintViolation.getPropertyPath().toString();
            String attributeName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, propertyFieldName);
            ConfigurationMetadata.AttributeMetadata attribute = configurationMetadata.getAttributes().get(attributeName);
            if (attribute != null && attribute.getInjectionPoint() != null) {
                Object propertyName = attribute.getInjectionPoint().getProperty();
                if (!prefix.isEmpty()) {
                    propertyName = prefix + (String)propertyName;
                }
                problems.addError("Invalid configuration property %s: %s (for class %s.%s)", propertyName, constraintViolation.getMessage(), configClass.getName(), constraintViolation.getPropertyPath());
                continue;
            }
            problems.addError("Invalid configuration property with prefix '%s': %s (for class %s.%s)", prefix, constraintViolation.getMessage(), configClass.getName(), constraintViolation.getPropertyPath());
        }
        problems.throwIfHasErrors();
        return new ConfigurationHolder<T>(instance, problems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Set<ConstraintViolation<T>> validate(T instance) {
        Validator validator = VALIDATOR;
        synchronized (validator) {
            return VALIDATOR.validate(instance, new Class[0]);
        }
    }

    private <T> ConfigurationMetadata<T> getMetadata(Key<T> key) {
        return this.getMetadata(key.getTypeLiteral().getRawType());
    }

    private <T> ConfigurationMetadata<T> getMetadata(Class<T> configClass) {
        return (ConfigurationMetadata)METADATA_CACHE.getUnchecked(configClass);
    }

    private static <T> T newInstance(ConfigurationMetadata<T> configurationMetadata) {
        try {
            return configurationMetadata.getConstructor().newInstance(new Object[0]);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                e = e.getCause();
            }
            throw Problems.exceptionFor(e, "Error creating instance of configuration class [%s]", configurationMetadata.getConfigClass().getName());
        }
    }

    private <T> void setConfigProperty(T instance, ConfigurationMetadata.AttributeMetadata attribute, String prefix, Problems problems) throws InvalidConfigurationException {
        ConfigurationMetadata.InjectionPointMetaData injectionPoint = this.findOperativeInjectionPoint(attribute, prefix, problems);
        if (injectionPoint == null) {
            return;
        }
        if (injectionPoint.getSetter().isAnnotationPresent(Deprecated.class)) {
            problems.addWarning(ConfigurationFactory.describeDeprecation(prefix, injectionPoint), new Object[0]);
        }
        Object value = this.getInjectedValue(attribute, injectionPoint, prefix);
        try {
            injectionPoint.getSetter().invoke(instance, value);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                e = e.getCause();
            }
            throw new InvalidConfigurationException(e, String.format("Error invoking configuration method [%s]", injectionPoint.getSetter().toGenericString()));
        }
    }

    private static String describeDeprecation(String prefix, ConfigurationMetadata.InjectionPointMetaData injectionPoint) {
        Deprecated deprecated = injectionPoint.getSetter().getAnnotation(Deprecated.class);
        Object deprecationNotice = "Configuration property '%s' is deprecated".formatted(prefix + injectionPoint.getProperty());
        if (!deprecated.since().isBlank()) {
            deprecationNotice = (String)deprecationNotice + " since " + deprecated.since();
        }
        return (String)deprecationNotice + (deprecated.forRemoval() ? " and will be removed in the future" : " and should not be used");
    }

    private ConfigurationMetadata.InjectionPointMetaData findOperativeInjectionPoint(ConfigurationMetadata.AttributeMetadata attribute, String prefix, Problems problems) throws ConfigurationException {
        ConfigurationMetadata.InjectionPointMetaData operativeInjectionPoint = attribute.getInjectionPoint();
        String operativeName = null;
        String operativeValue = null;
        if (operativeInjectionPoint != null) {
            operativeName = prefix + operativeInjectionPoint.getProperty();
            operativeValue = this.properties.get(operativeName);
        }
        String printableOperativeValue = operativeValue;
        if (attribute.isSecuritySensitive()) {
            printableOperativeValue = "[REDACTED]";
        }
        for (ConfigurationMetadata.InjectionPointMetaData injectionPoint : attribute.getLegacyInjectionPoints()) {
            String value;
            String fullName = prefix + injectionPoint.getProperty();
            String printableValue = value = this.properties.get(fullName);
            if (attribute.isSecuritySensitive()) {
                printableValue = "[REDACTED]";
            }
            if (value == null) continue;
            String replacement = "deprecated.";
            if (attribute.getInjectionPoint() != null) {
                replacement = String.format("replaced. Use '%s' instead.", prefix + attribute.getInjectionPoint().getProperty());
            }
            problems.addWarning("Configuration property '%s' has been " + replacement, fullName);
            if (operativeValue == null) {
                operativeInjectionPoint = injectionPoint;
                operativeValue = value;
                printableOperativeValue = printableValue;
                operativeName = fullName;
                continue;
            }
            problems.addError("Configuration property '%s' (=%s) conflicts with property '%s' (=%s)", fullName, printableValue, operativeName, printableOperativeValue);
        }
        problems.throwIfHasErrors();
        if (operativeValue == null) {
            return null;
        }
        return operativeInjectionPoint;
    }

    private Object getInjectedValue(ConfigurationMetadata.AttributeMetadata attribute, ConfigurationMetadata.InjectionPointMetaData injectionPoint, String prefix) throws InvalidConfigurationException {
        String value;
        String name = prefix + injectionPoint.getProperty();
        this.usedProperties.add(new ConfigPropertyMetadata(name, attribute.isSecuritySensitive()));
        String printableValue = value = this.properties.get(name);
        if (attribute.isSecuritySensitive()) {
            printableValue = "[REDACTED]";
        }
        if (value == null) {
            return null;
        }
        TypeToken propertyType = TypeToken.of((Type)injectionPoint.getSetter().getGenericParameterTypes()[0]);
        Object finalValue = ConfigurationFactory.coerce(propertyType, value);
        if (finalValue == null) {
            throw new InvalidConfigurationException(String.format("Invalid value '%s' for type %s (property '%s') in order to call [%s]", printableValue, propertyType.getType().getTypeName(), name, injectionPoint.getSetter().toGenericString()));
        }
        return finalValue;
    }

    private static Object coerce(TypeToken<?> type, String value) {
        Method of;
        Method valueOf;
        TypeToken<?> argumentToken;
        Method fromString22;
        if (type.isPrimitive() && value == null) {
            return null;
        }
        try {
            if (String.class == type.getRawType()) {
                return value;
            }
            if (Boolean.class == type.getRawType() || Boolean.TYPE == type.getRawType()) {
                if ("true".equalsIgnoreCase(value)) {
                    return Boolean.TRUE;
                }
                if ("false".equalsIgnoreCase(value)) {
                    return Boolean.FALSE;
                }
                return null;
            }
            if (Byte.class == type.getRawType() || Byte.TYPE == type.getRawType()) {
                return Byte.valueOf(value);
            }
            if (Short.class == type.getRawType() || Short.TYPE == type.getRawType()) {
                return Short.valueOf(value);
            }
            if (Integer.class == type.getRawType() || Integer.TYPE == type.getRawType()) {
                return Integer.valueOf(value);
            }
            if (Long.class == type.getRawType() || Long.TYPE == type.getRawType()) {
                return Long.valueOf(value);
            }
            if (Float.class == type.getRawType() || Float.TYPE == type.getRawType()) {
                return Float.valueOf(value);
            }
            if (Double.class == type.getRawType() || Double.TYPE == type.getRawType()) {
                return Double.valueOf(value);
            }
        }
        catch (Exception ignored) {
            return null;
        }
        Map stringAcceptingMethods = (Map)Arrays.stream(type.getRawType().getMethods()).filter(method -> Modifier.isStatic(method.getModifiers())).filter(ConfigurationFactory::acceptsSingleStringParameter).collect(ImmutableMap.toImmutableMap(Method::getName, Function.identity()));
        Object v = stringAcceptingMethods.get("fromString");
        if (v instanceof Method && type.isSubtypeOf((fromString22 = (Method)v).getGenericReturnType())) {
            try {
                return ConfigurationFactory.invokeFactory(fromString22, value);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                return null;
            }
        }
        if (type.isSubtypeOf(TypeToken.of(Enum.class))) {
            try {
                return Enum.valueOf(type.getRawType().asSubclass(Enum.class), value.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException fromString22) {
                Enum match = null;
                for (Enum option : type.getRawType().asSubclass(Enum.class).getEnumConstants()) {
                    String enumValue = value.replace("-", "_");
                    if (!option.name().equalsIgnoreCase(enumValue)) continue;
                    if (match != null) {
                        return null;
                    }
                    match = option;
                }
                return match;
            }
        }
        if (type.isSubtypeOf(TypeToken.of(Set.class))) {
            argumentToken = ConfigurationFactory.getActualTypeArgument(type);
            return VALUE_SPLITTER.splitToStream((CharSequence)value).map(item -> ConfigurationFactory.coerce(argumentToken, item)).collect(ImmutableSet.toImmutableSet());
        }
        if (type.isSubtypeOf(TypeToken.of(List.class))) {
            argumentToken = ConfigurationFactory.getActualTypeArgument(type);
            return VALUE_SPLITTER.splitToStream((CharSequence)value).map(item -> ConfigurationFactory.coerce(argumentToken, item)).collect(ImmutableList.toImmutableList());
        }
        if (type.isSubtypeOf(TypeToken.of(Optional.class))) {
            argumentToken = ConfigurationFactory.getActualTypeArgument(type);
            return Optional.ofNullable(ConfigurationFactory.coerce(argumentToken, value));
        }
        Object v2 = stringAcceptingMethods.get("valueOf");
        if (v2 instanceof Method && type.isSubtypeOf((valueOf = (Method)v2).getGenericReturnType())) {
            try {
                return ConfigurationFactory.invokeFactory(valueOf, value);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                return null;
            }
        }
        Object v3 = stringAcceptingMethods.get("of");
        if (v3 instanceof Method && type.isSubtypeOf((of = (Method)v3).getGenericReturnType())) {
            try {
                return ConfigurationFactory.invokeFactory(of, value);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                return null;
            }
        }
        for (Constructor<?> constructor : type.getRawType().getConstructors()) {
            if (!ConfigurationFactory.acceptsSingleStringParameter(constructor)) continue;
            try {
                if (constructor.isVarArgs()) {
                    return constructor.newInstance(value, new String[0]);
                }
                return constructor.newInstance(value);
            }
            catch (ReflectiveOperationException e4) {
                return null;
            }
        }
        return null;
    }

    private static boolean acceptsSingleStringParameter(Executable executable) {
        if (executable.getParameterCount() == 1) {
            return executable.getParameters()[0].getType() == String.class;
        }
        if (executable.isVarArgs() && executable.getParameterCount() == 2) {
            return executable.getParameters()[0].getType() == String.class && executable.getParameters()[1].getType() == String[].class;
        }
        return false;
    }

    private static TypeToken<?> getActualTypeArgument(TypeToken<?> type) {
        ParameterizedType argumentType = (ParameterizedType)type.getType();
        Verify.verify((argumentType.getActualTypeArguments().length == 1 ? 1 : 0) != 0, (String)"Expected type %s to be parametrized", type);
        return TypeToken.of((Type)argumentType.getActualTypeArguments()[0]);
    }

    private static Object invokeFactory(Method factory, String value) throws ReflectiveOperationException {
        if (factory.isVarArgs()) {
            return factory.invoke(null, value, new String[0]);
        }
        return factory.invoke(null, value);
    }

    static {
        VALUE_SPLITTER = Splitter.on((String)",").omitEmptyStrings().trimResults();
        METADATA_CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(ConfigurationMetadata::getConfigurationMetadata));
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(null);
            VALIDATOR = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).externalClassLoader(HibernateValidator.class.getClassLoader())).ignoreXmlConfiguration()).messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator(Set.of(Locale.ENGLISH), Locale.ENGLISH, false))).buildValidatorFactory().getValidator();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private class ConfigurationProviderConsumer
    implements Consumer<ConfigurationProvider<?>> {
        private final ConfigurationBindingListener listener;
        private final ConfigBinder configBinder;

        public ConfigurationProviderConsumer(ConfigurationFactory configurationFactory, ConfigurationBindingListener listener) {
            this.listener = listener;
            this.configBinder = ConfigBinder.configBinder(configurationFactory, Optional.of(listener));
        }

        @Override
        public void accept(ConfigurationProvider<?> configurationProvider) {
            this.listener.configurationBound(configurationProvider.getConfigurationBinding(), this.configBinder);
        }
    }

    private static class ConfigurationHolder<T> {
        private final T instance;
        private final Problems problems;

        private ConfigurationHolder(T instance, Problems problems) {
            this.instance = instance;
            this.problems = problems;
        }

        public T getInstance() {
            return this.instance;
        }

        public Problems getProblems() {
            return this.problems;
        }
    }
}

