/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem;

import com.google.common.collect.ImmutableMap;
import io.airlift.stats.TDigest;
import io.trino.plugin.base.metrics.LongCount;
import io.trino.plugin.base.metrics.TDigestHistogram;
import io.trino.spi.metrics.Metric;
import io.trino.spi.metrics.Metrics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class MetricsBuilder {
    public static final String SOURCE_FILES_PROCESSED = "FileSystemExchangeSource.filesProcessed";
    private final ConcurrentMap<String, MetricBuilder> metricBuilders = new ConcurrentHashMap<String, MetricBuilder>();

    public Metrics buildMetrics() {
        return new Metrics((Map)this.metricBuilders.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((MetricBuilder)entry.getValue()).build())));
    }

    public CounterMetricBuilder getCounterMetric(String key) {
        return (CounterMetricBuilder)this.metricBuilders.computeIfAbsent(key, string -> new CounterMetricBuilder());
    }

    public DistributionMetricBuilder getDistributionMetric(String key) {
        return (DistributionMetricBuilder)this.metricBuilders.computeIfAbsent(key, string -> new DistributionMetricBuilder());
    }

    public static class CounterMetricBuilder
    implements MetricBuilder {
        private final AtomicLong counter = new AtomicLong();

        public void increment() {
            this.counter.incrementAndGet();
        }

        public void add(long delta) {
            this.counter.addAndGet(delta);
        }

        @Override
        public Metric<?> build() {
            return new LongCount(this.counter.get());
        }
    }

    public static class DistributionMetricBuilder
    implements MetricBuilder {
        private final TDigest digest = new TDigest();

        public synchronized void add(double value) {
            this.digest.add(value);
        }

        @Override
        public synchronized Metric<?> build() {
            return new TDigestHistogram(TDigest.copyOf((TDigest)this.digest));
        }
    }

    private static interface MetricBuilder {
        public Metric<?> build();
    }
}

