/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.hdfs;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.plugin.base.jmx.PrefixObjectNameGeneratorModule;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeManager;
import io.trino.plugin.exchange.hdfs.HdfsExchangeModule;
import io.trino.spi.exchange.ExchangeManager;
import io.trino.spi.exchange.ExchangeManagerFactory;
import java.util.Map;
import java.util.Objects;
import org.weakref.jmx.guice.MBeanModule;

public class HdfsExchangeManagerFactory
implements ExchangeManagerFactory {
    static final String NAME = "hdfs";

    public String getName() {
        return NAME;
    }

    public ExchangeManager create(Map<String, String> config) {
        Objects.requireNonNull(config, "config is null");
        Bootstrap app = new Bootstrap(new Module[]{new MBeanModule(), new MBeanServerModule(), new PrefixObjectNameGeneratorModule("io.trino.plugin.exchange.hdfs", "trino.plugin.exchange.hdfs"), new HdfsExchangeModule()});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (ExchangeManager)injector.getInstance(FileSystemExchangeManager.class);
    }
}

