/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import io.trino.hadoop.$internal.com.fasterxml.jackson.databind.ObjectMapper;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.web.WebHdfsConstants;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.StringUtils;

public class JsonUtil {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String toJsonString(Token<? extends TokenIdentifier> token) throws IOException {
        return JsonUtil.toJsonString(Token.class, JsonUtil.toJsonMap(token));
    }

    private static Map<String, Object> toJsonMap(Token<? extends TokenIdentifier> token) throws IOException {
        if (token == null) {
            return null;
        }
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("urlString", token.encodeToUrlString());
        return m3;
    }

    public static String toJsonString(Exception e) {
        TreeMap<String, String> m3 = new TreeMap<String, String>();
        m3.put("exception", e.getClass().getSimpleName());
        m3.put("message", e.getMessage());
        m3.put("javaClassName", e.getClass().getName());
        return JsonUtil.toJsonString(RemoteException.class, m3);
    }

    private static String toJsonString(Class<?> clazz, Object value) {
        return JsonUtil.toJsonString(clazz.getSimpleName(), value);
    }

    public static String toJsonString(String key, Object value) {
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put(key, value);
        try {
            return MAPPER.writeValueAsString(m3);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String toString(FsPermission permission) {
        return String.format("%o", permission.toShort());
    }

    public static String toJsonString(HdfsFileStatus status, boolean includeType) {
        if (status == null) {
            return null;
        }
        Map<String, Object> m3 = JsonUtil.toJsonMap(status);
        try {
            return includeType ? JsonUtil.toJsonString(FileStatus.class, m3) : MAPPER.writeValueAsString(m3);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Map<String, Object> toJsonMap(HdfsFileStatus status) {
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("pathSuffix", status.getLocalName());
        m3.put("type", (Object)WebHdfsConstants.PathType.valueOf(status));
        if (status.isSymlink()) {
            m3.put("symlink", DFSUtilClient.bytes2String(status.getSymlinkInBytes()));
        }
        m3.put("length", status.getLen());
        m3.put("owner", status.getOwner());
        m3.put("group", status.getGroup());
        FsPermission perm = status.getPermission();
        m3.put("permission", JsonUtil.toString(perm));
        if (status.hasAcl()) {
            m3.put("aclBit", true);
        }
        if (status.isEncrypted()) {
            m3.put("encBit", true);
        }
        if (status.isErasureCoded()) {
            m3.put("ecBit", true);
            if (status.getErasureCodingPolicy() != null) {
                m3.put("ecPolicy", status.getErasureCodingPolicy().getName());
                m3.put("ecPolicyObj", JsonUtil.getEcPolicyAsMap(status.getErasureCodingPolicy()));
            }
        }
        if (status.isSnapshotEnabled()) {
            m3.put("snapshotEnabled", status.isSnapshotEnabled());
        }
        m3.put("accessTime", status.getAccessTime());
        m3.put("modificationTime", status.getModificationTime());
        m3.put("blockSize", status.getBlockSize());
        m3.put("replication", status.getReplication());
        m3.put("fileId", status.getFileId());
        m3.put("childrenNum", status.getChildrenNum());
        m3.put("storagePolicy", status.getStoragePolicy());
        return m3;
    }

    public static Map<String, Object> getEcPolicyAsMap(ErasureCodingPolicy ecPolicy) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        builder.put("name", ecPolicy.getName()).put("cellSize", (String)((Object)Integer.valueOf(ecPolicy.getCellSize()))).put("numDataUnits", (String)((Object)Integer.valueOf(ecPolicy.getNumDataUnits()))).put("numParityUnits", (String)((Object)Integer.valueOf(ecPolicy.getNumParityUnits()))).put("codecName", ecPolicy.getCodecName()).put("id", (String)((Object)Byte.valueOf(ecPolicy.getId()))).put("extraOptions", (String)((Object)ecPolicy.getSchema().getExtraOptions()));
        return builder.build();
    }

    private static Map<String, Object> toJsonMap(ExtendedBlock extendedblock) {
        if (extendedblock == null) {
            return null;
        }
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("blockPoolId", extendedblock.getBlockPoolId());
        m3.put("blockId", extendedblock.getBlockId());
        m3.put("numBytes", extendedblock.getNumBytes());
        m3.put("generationStamp", extendedblock.getGenerationStamp());
        return m3;
    }

    static Map<String, Object> toJsonMap(DatanodeInfo datanodeinfo) {
        if (datanodeinfo == null) {
            return null;
        }
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("ipAddr", datanodeinfo.getIpAddr());
        m3.put("name", datanodeinfo.getXferAddr());
        m3.put("hostName", datanodeinfo.getHostName());
        m3.put("storageID", datanodeinfo.getDatanodeUuid());
        m3.put("xferPort", datanodeinfo.getXferPort());
        m3.put("infoPort", datanodeinfo.getInfoPort());
        m3.put("infoSecurePort", datanodeinfo.getInfoSecurePort());
        m3.put("ipcPort", datanodeinfo.getIpcPort());
        m3.put("capacity", datanodeinfo.getCapacity());
        m3.put("dfsUsed", datanodeinfo.getDfsUsed());
        m3.put("remaining", datanodeinfo.getRemaining());
        m3.put("blockPoolUsed", datanodeinfo.getBlockPoolUsed());
        m3.put("cacheCapacity", datanodeinfo.getCacheCapacity());
        m3.put("cacheUsed", datanodeinfo.getCacheUsed());
        m3.put("lastUpdate", datanodeinfo.getLastUpdate());
        m3.put("lastUpdateMonotonic", datanodeinfo.getLastUpdateMonotonic());
        m3.put("xceiverCount", datanodeinfo.getXceiverCount());
        m3.put("networkLocation", datanodeinfo.getNetworkLocation());
        m3.put("adminState", datanodeinfo.getAdminState().name());
        if (datanodeinfo.getUpgradeDomain() != null) {
            m3.put("upgradeDomain", datanodeinfo.getUpgradeDomain());
        }
        m3.put("lastBlockReportTime", datanodeinfo.getLastBlockReportTime());
        m3.put("lastBlockReportMonotonic", datanodeinfo.getLastBlockReportMonotonic());
        return m3;
    }

    private static Object[] toJsonArray(DatanodeInfo[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = JsonUtil.toJsonMap(array[i]);
        }
        return a;
    }

    private static Object[] toJsonArray(StorageType[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = array[i];
        }
        return a;
    }

    private static Map<String, Object> toJsonMap(LocatedBlock locatedblock) throws IOException {
        if (locatedblock == null) {
            return null;
        }
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("blockToken", JsonUtil.toJsonMap(locatedblock.getBlockToken()));
        m3.put("isCorrupt", locatedblock.isCorrupt());
        m3.put("startOffset", locatedblock.getStartOffset());
        m3.put("block", JsonUtil.toJsonMap(locatedblock.getBlock()));
        m3.put("storageTypes", JsonUtil.toJsonArray(locatedblock.getStorageTypes()));
        m3.put("locations", JsonUtil.toJsonArray(locatedblock.getLocations()));
        m3.put("cachedLocations", JsonUtil.toJsonArray(locatedblock.getCachedLocations()));
        return m3;
    }

    private static Map<String, Object> toJson(DirectoryListing listing) throws IOException {
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("partialListing", JsonUtil.toJsonMap(listing.getPartialListing()));
        m3.put("remainingEntries", listing.getRemainingEntries());
        return m3;
    }

    public static String toJsonString(DirectoryListing listing) throws IOException {
        if (listing == null) {
            return null;
        }
        return JsonUtil.toJsonString(DirectoryListing.class, JsonUtil.toJson(listing));
    }

    private static Map<String, Object> toJsonMap(HdfsFileStatus[] statuses) throws IOException {
        if (statuses == null) {
            return null;
        }
        TreeMap<String, Object> fileStatuses = new TreeMap<String, Object>();
        TreeMap<String, Object[]> fileStatus = new TreeMap<String, Object[]>();
        fileStatuses.put("FileStatuses", fileStatus);
        Object[] array = new Object[statuses.length];
        fileStatus.put("FileStatus", array);
        for (int i = 0; i < statuses.length; ++i) {
            array[i] = JsonUtil.toJsonMap(statuses[i]);
        }
        return fileStatuses;
    }

    private static Object[] toJsonArray(List<LocatedBlock> array) throws IOException {
        if (array == null) {
            return null;
        }
        if (array.size() == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            a[i] = JsonUtil.toJsonMap(array.get(i));
        }
        return a;
    }

    public static String toJsonString(LocatedBlocks locatedblocks) throws IOException {
        if (locatedblocks == null) {
            return null;
        }
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("fileLength", locatedblocks.getFileLength());
        m3.put("isUnderConstruction", locatedblocks.isUnderConstruction());
        m3.put("locatedBlocks", JsonUtil.toJsonArray(locatedblocks.getLocatedBlocks()));
        m3.put("lastLocatedBlock", JsonUtil.toJsonMap(locatedblocks.getLastLocatedBlock()));
        m3.put("isLastBlockComplete", locatedblocks.isLastBlockComplete());
        return JsonUtil.toJsonString(LocatedBlocks.class, m3);
    }

    public static String toJsonString(ContentSummary contentsummary) {
        if (contentsummary == null) {
            return null;
        }
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("length", contentsummary.getLength());
        m3.put("fileCount", contentsummary.getFileCount());
        m3.put("directoryCount", contentsummary.getDirectoryCount());
        m3.put("ecPolicy", contentsummary.getErasureCodingPolicy());
        m3.putAll(JsonUtil.toJsonMap(contentsummary, false));
        m3.put("snapshotLength", contentsummary.getSnapshotLength());
        m3.put("snapshotFileCount", contentsummary.getSnapshotFileCount());
        m3.put("snapshotDirectoryCount", contentsummary.getSnapshotDirectoryCount());
        m3.put("snapshotSpaceConsumed", contentsummary.getSnapshotSpaceConsumed());
        return JsonUtil.toJsonString(ContentSummary.class, m3);
    }

    public static String toJsonString(QuotaUsage quotaUsage) {
        if (quotaUsage == null) {
            return null;
        }
        return JsonUtil.toJsonString(QuotaUsage.class, JsonUtil.toJsonMap(quotaUsage, true));
    }

    private static Map<String, Object> toJsonMap(QuotaUsage quotaUsage, boolean includeFileAndDirectoryCount) {
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        if (includeFileAndDirectoryCount) {
            m3.put("fileAndDirectoryCount", quotaUsage.getFileAndDirectoryCount());
        }
        m3.put("quota", quotaUsage.getQuota());
        m3.put("spaceConsumed", quotaUsage.getSpaceConsumed());
        m3.put("spaceQuota", quotaUsage.getSpaceQuota());
        TreeMap<String, TreeMap<String, Long>> typeQuota = new TreeMap<String, TreeMap<String, Long>>();
        for (StorageType t : StorageType.getTypesSupportingQuota()) {
            long tQuota = quotaUsage.getTypeQuota(t);
            if (tQuota == -1L) continue;
            TreeMap<String, Long> type = (TreeMap<String, Long>)typeQuota.get(t.toString());
            if (type == null) {
                type = new TreeMap<String, Long>();
                typeQuota.put(t.toString(), type);
            }
            type.put("quota", quotaUsage.getTypeQuota(t));
            type.put("consumed", quotaUsage.getTypeConsumed(t));
        }
        m3.put("typeQuota", typeQuota);
        return m3;
    }

    public static String toJsonString(MD5MD5CRC32FileChecksum checksum) {
        if (checksum == null) {
            return null;
        }
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("algorithm", checksum.getAlgorithmName());
        m3.put("length", checksum.getLength());
        m3.put("bytes", StringUtils.byteToHexString(checksum.getBytes()));
        return JsonUtil.toJsonString(FileChecksum.class, m3);
    }

    public static String toJsonString(AclStatus status) {
        if (status == null) {
            return null;
        }
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("owner", status.getOwner());
        m3.put("group", status.getGroup());
        m3.put("stickyBit", status.isStickyBit());
        ArrayList<String> stringEntries = new ArrayList<String>();
        for (AclEntry entry : status.getEntries()) {
            stringEntries.add(entry.toStringStable());
        }
        m3.put("entries", stringEntries);
        FsPermission perm = status.getPermission();
        if (perm != null) {
            m3.put("permission", JsonUtil.toString(perm));
        }
        TreeMap<String, TreeMap<String, Object>> finalMap = new TreeMap<String, TreeMap<String, Object>>();
        finalMap.put(AclStatus.class.getSimpleName(), m3);
        try {
            return MAPPER.writeValueAsString(finalMap);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Map<String, Object> toJsonMap(XAttr xAttr, XAttrCodec encoding) throws IOException {
        if (xAttr == null) {
            return null;
        }
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("name", XAttrHelper.getPrefixedName(xAttr));
        m3.put("value", xAttr.getValue() != null ? XAttrCodec.encodeValue(xAttr.getValue(), encoding) : null);
        return m3;
    }

    private static Object[] toJsonArray(List<XAttr> array, XAttrCodec encoding) throws IOException {
        if (array == null) {
            return null;
        }
        if (array.size() == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            a[i] = JsonUtil.toJsonMap(array.get(i), encoding);
        }
        return a;
    }

    public static String toJsonString(List<XAttr> xAttrs, XAttrCodec encoding) throws IOException {
        TreeMap<String, Object[]> finalMap = new TreeMap<String, Object[]>();
        finalMap.put("XAttrs", JsonUtil.toJsonArray(xAttrs, encoding));
        return MAPPER.writeValueAsString(finalMap);
    }

    public static String toJsonString(List<XAttr> xAttrs) throws IOException {
        ArrayList<String> names = Lists.newArrayListWithCapacity(xAttrs.size());
        for (XAttr xAttr : xAttrs) {
            names.add(XAttrHelper.getPrefixedName(xAttr));
        }
        String ret = MAPPER.writeValueAsString(names);
        TreeMap<String, String> finalMap = new TreeMap<String, String>();
        finalMap.put("XAttrNames", ret);
        return MAPPER.writeValueAsString(finalMap);
    }

    public static String toJsonString(Object obj) throws IOException {
        return MAPPER.writeValueAsString(obj);
    }

    public static String toJsonString(BlockStoragePolicy[] storagePolicies) {
        TreeMap<String, Object[]> blockStoragePolicies = new TreeMap<String, Object[]>();
        Object[] a = null;
        if (storagePolicies != null && storagePolicies.length > 0) {
            a = new Object[storagePolicies.length];
            for (int i = 0; i < storagePolicies.length; ++i) {
                a[i] = JsonUtil.toJsonMap(storagePolicies[i]);
            }
        }
        blockStoragePolicies.put("BlockStoragePolicy", a);
        return JsonUtil.toJsonString("BlockStoragePolicies", blockStoragePolicies);
    }

    private static Object toJsonMap(BlockStoragePolicy blockStoragePolicy) {
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("id", blockStoragePolicy.getId());
        m3.put("name", blockStoragePolicy.getName());
        m3.put("storageTypes", blockStoragePolicy.getStorageTypes());
        m3.put("creationFallbacks", blockStoragePolicy.getCreationFallbacks());
        m3.put("replicationFallbacks", blockStoragePolicy.getReplicationFallbacks());
        m3.put("copyOnCreateFile", blockStoragePolicy.isCopyOnCreateFile());
        return m3;
    }

    public static String toJsonString(BlockStoragePolicy storagePolicy) {
        return JsonUtil.toJsonString(BlockStoragePolicy.class, JsonUtil.toJsonMap(storagePolicy));
    }

    public static String toJsonString(FsServerDefaults serverDefaults) {
        return JsonUtil.toJsonString(FsServerDefaults.class, JsonUtil.toJsonMap(serverDefaults));
    }

    private static Object toJsonMap(FsServerDefaults serverDefaults) {
        HashMap<String, Object> m3 = new HashMap<String, Object>();
        m3.put("blockSize", serverDefaults.getBlockSize());
        m3.put("bytesPerChecksum", serverDefaults.getBytesPerChecksum());
        m3.put("writePacketSize", serverDefaults.getWritePacketSize());
        m3.put("replication", serverDefaults.getReplication());
        m3.put("fileBufferSize", serverDefaults.getFileBufferSize());
        m3.put("encryptDataTransfer", serverDefaults.getEncryptDataTransfer());
        m3.put("trashInterval", serverDefaults.getTrashInterval());
        m3.put("checksumType", serverDefaults.getChecksumType().id);
        m3.put("keyProviderUri", serverDefaults.getKeyProviderUri());
        m3.put("defaultStoragePolicyId", serverDefaults.getDefaultStoragePolicyId());
        return m3;
    }

    public static String toJsonString(SnapshotDiffReport diffReport) {
        return JsonUtil.toJsonString(SnapshotDiffReport.class.getSimpleName(), JsonUtil.toJsonMap(diffReport));
    }

    private static Object toJsonMap(SnapshotDiffReport diffReport) {
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("snapshotRoot", diffReport.getSnapshotRoot());
        m3.put("fromSnapshot", diffReport.getFromSnapshot());
        m3.put("toSnapshot", diffReport.getLaterSnapshotName());
        Object[] diffList = new Object[diffReport.getDiffList().size()];
        for (int i = 0; i < diffReport.getDiffList().size(); ++i) {
            diffList[i] = JsonUtil.toJsonMap(diffReport.getDiffList().get(i));
        }
        m3.put("diffList", diffList);
        return m3;
    }

    private static Object toJsonMap(SnapshotDiffReport.DiffReportEntry diffReportEntry) {
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("type", (Object)diffReportEntry.getType());
        if (diffReportEntry.getSourcePath() != null) {
            m3.put("sourcePath", DFSUtilClient.bytes2String(diffReportEntry.getSourcePath()));
        }
        if (diffReportEntry.getTargetPath() != null) {
            m3.put("targetPath", DFSUtilClient.bytes2String(diffReportEntry.getTargetPath()));
        }
        return m3;
    }

    public static String toJsonString(SnapshottableDirectoryStatus[] snapshottableDirectoryList) {
        if (snapshottableDirectoryList == null) {
            return JsonUtil.toJsonString("SnapshottableDirectoryList", null);
        }
        Object[] a = new Object[snapshottableDirectoryList.length];
        for (int i = 0; i < snapshottableDirectoryList.length; ++i) {
            a[i] = JsonUtil.toJsonMap(snapshottableDirectoryList[i]);
        }
        return JsonUtil.toJsonString("SnapshottableDirectoryList", (Object)a);
    }

    private static Object toJsonMap(SnapshottableDirectoryStatus snapshottableDirectoryStatus) {
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("snapshotNumber", snapshottableDirectoryStatus.getSnapshotNumber());
        m3.put("snapshotQuota", snapshottableDirectoryStatus.getSnapshotQuota());
        m3.put("parentFullPath", DFSUtilClient.bytes2String(snapshottableDirectoryStatus.getParentFullPath()));
        m3.put("dirStatus", JsonUtil.toJsonMap(snapshottableDirectoryStatus.getDirStatus()));
        return m3;
    }

    private static Map<String, Object> toJsonMap(BlockLocation blockLocation) throws IOException {
        if (blockLocation == null) {
            return null;
        }
        HashMap<String, Object> m3 = new HashMap<String, Object>();
        m3.put("length", blockLocation.getLength());
        m3.put("offset", blockLocation.getOffset());
        m3.put("corrupt", blockLocation.isCorrupt());
        m3.put("storageTypes", JsonUtil.toJsonArray(blockLocation.getStorageTypes()));
        m3.put("cachedHosts", blockLocation.getCachedHosts());
        m3.put("hosts", blockLocation.getHosts());
        m3.put("names", blockLocation.getNames());
        m3.put("topologyPaths", blockLocation.getTopologyPaths());
        return m3;
    }

    public static String toJsonString(BlockLocation[] locations) throws IOException {
        if (locations == null) {
            return null;
        }
        HashMap<String, Object[]> m3 = new HashMap<String, Object[]>();
        Object[] blockLocations = new Object[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            blockLocations[i] = JsonUtil.toJsonMap(locations[i]);
        }
        m3.put(BlockLocation.class.getSimpleName(), blockLocations);
        return JsonUtil.toJsonString("BlockLocations", m3);
    }
}

