/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.metrics;

import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.protocol.OutlierMetrics;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class OutlierDetector {
    public static final Logger LOG = LoggerFactory.getLogger(OutlierDetector.class);
    private volatile long minNumResources;
    private static final double MAD_MULTIPLIER = 1.4826;
    private volatile long lowThresholdMs;
    private static final int DEVIATION_MULTIPLIER = 3;
    @VisibleForTesting
    static final int MEDIAN_MULTIPLIER = 3;

    public OutlierDetector(long minNumResources, long lowThresholdMs) {
        this.minNumResources = minNumResources;
        this.lowThresholdMs = lowThresholdMs;
    }

    public Map<String, Double> getOutliers(Map<String, Double> stats) {
        HashMap<String, Double> slowResources = new HashMap<String, Double>();
        Map<String, OutlierMetrics> slowResourceMetrics = this.getOutlierMetrics(stats);
        slowResourceMetrics.forEach((node, outlierMetrics) -> slowResources.put((String)node, outlierMetrics.getActualLatency()));
        return slowResources;
    }

    public Map<String, OutlierMetrics> getOutlierMetrics(Map<String, Double> stats) {
        if ((long)stats.size() < this.minNumResources) {
            LOG.debug("Skipping statistical outlier detection as we don't have latency data for enough resources. Have {}, need at least {}", (Object)stats.size(), (Object)this.minNumResources);
            return ImmutableMap.of();
        }
        ArrayList<Double> sorted = new ArrayList<Double>(stats.values());
        Collections.sort(sorted);
        Double median = OutlierDetector.computeMedian(sorted);
        Double mad = OutlierDetector.computeMad(sorted);
        Double upperLimitLatency = Math.max((double)this.lowThresholdMs, median * 3.0);
        upperLimitLatency = Math.max(upperLimitLatency, median + 3.0 * mad);
        HashMap<String, OutlierMetrics> slowResources = new HashMap<String, OutlierMetrics>();
        LOG.trace("getOutliers: List={}, MedianLatency={}, MedianAbsoluteDeviation={}, upperLimitLatency={}", sorted, median, mad, upperLimitLatency);
        for (Map.Entry<String, Double> entry : stats.entrySet()) {
            if (!(entry.getValue() > upperLimitLatency)) continue;
            OutlierMetrics outlierMetrics = new OutlierMetrics(median, mad, upperLimitLatency, entry.getValue());
            slowResources.put(entry.getKey(), outlierMetrics);
        }
        return slowResources;
    }

    public static Double computeMad(List<Double> sortedValues) {
        if (sortedValues.size() == 0) {
            throw new IllegalArgumentException("Cannot compute the Median Absolute Deviation of an empty list.");
        }
        Double median = OutlierDetector.computeMedian(sortedValues);
        ArrayList<Double> deviations = new ArrayList<Double>(sortedValues);
        for (int i = 0; i < sortedValues.size(); ++i) {
            deviations.set(i, Math.abs(sortedValues.get(i) - median));
        }
        Collections.sort(deviations);
        return OutlierDetector.computeMedian(deviations) * 1.4826;
    }

    public static Double computeMedian(List<Double> sortedValues) {
        if (sortedValues.size() == 0) {
            throw new IllegalArgumentException("Cannot compute the median of an empty list.");
        }
        Double median = sortedValues.get(sortedValues.size() / 2);
        if (sortedValues.size() % 2 == 0) {
            median = median + sortedValues.get(sortedValues.size() / 2 - 1);
            median = median / 2.0;
        }
        return median;
    }

    public void setMinNumResources(long minNodes) {
        this.minNumResources = minNodes;
    }

    public long getMinOutlierDetectionNodes() {
        return this.minNumResources;
    }

    public void setLowThresholdMs(long thresholdMs) {
        this.lowThresholdMs = thresholdMs;
    }

    public long getLowThresholdMs() {
        return this.lowThresholdMs;
    }
}

