/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http.rest;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.FormParam;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Options;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnValueWireType;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.implementation.http.UnexpectedExceptionInformation;
import com.azure.core.implementation.http.rest.HeaderSubstitution;
import com.azure.core.implementation.http.rest.MissingRequiredAnnotationException;
import com.azure.core.implementation.http.rest.QuerySubstitution;
import com.azure.core.implementation.http.rest.RangeReplaceSubstitution;
import com.azure.core.implementation.http.rest.Substitution;
import com.azure.core.implementation.http.rest.SwaggerInterfaceParser;
import com.azure.core.implementation.http.rest.UrlEscapers;
import com.azure.core.implementation.serializer.HttpResponseDecodeData;
import com.azure.core.util.Base64Url;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.ExpandableStringEnum;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.serializer.SerializerAdapter;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SwaggerMethodParser
implements HttpResponseDecodeData {
    private static final List<Class<? extends Annotation>> REQUIRED_HTTP_METHODS = Arrays.asList(Delete.class, Get.class, Head.class, Options.class, Patch.class, Post.class, Put.class);
    private final String rawHost;
    private final String fullyQualifiedMethodName;
    private final HttpMethod httpMethod;
    private final String relativePath;
    final List<RangeReplaceSubstitution> hostSubstitutions = new ArrayList<RangeReplaceSubstitution>();
    private final List<RangeReplaceSubstitution> pathSubstitutions = new ArrayList<RangeReplaceSubstitution>();
    private final List<QuerySubstitution> querySubstitutions = new ArrayList<QuerySubstitution>();
    private final List<Substitution> formSubstitutions = new ArrayList<Substitution>();
    private final List<HeaderSubstitution> headerSubstitutions = new ArrayList<HeaderSubstitution>();
    private final HttpHeaders headers = new HttpHeaders();
    private final Integer bodyContentMethodParameterIndex;
    private final String bodyContentType;
    private final Type bodyJavaType;
    private final BitSet expectedStatusCodes;
    private final Type returnType;
    private final Type returnValueWireType;
    private final UnexpectedResponseExceptionType[] unexpectedResponseExceptionTypes;
    private final int contextPosition;
    private final int requestOptionsPosition;
    private final boolean isReactive;
    private final boolean isStreamResponse;
    private final boolean returnTypeDecodeable;
    private final boolean responseEagerlyRead;
    private final boolean ignoreResponseBody;
    private final boolean headersEagerlyConverted;
    private final String spanName;
    private Map<Integer, UnexpectedExceptionInformation> exceptionMapping;
    private UnexpectedExceptionInformation defaultException;

    public SwaggerMethodParser(Method swaggerMethod) {
        this(SwaggerInterfaceParser.getInstance(swaggerMethod.getDeclaringClass()), swaggerMethod);
    }

    /*
     * WARNING - void declaration
     */
    SwaggerMethodParser(SwaggerInterfaceParser interfaceParser, Method swaggerMethod) {
        void var6_10;
        ExpectedResponses expectedResponses;
        Class<?> returnValueWireType;
        this.rawHost = interfaceParser.getHost();
        Class<?> swaggerInterface = swaggerMethod.getDeclaringClass();
        this.fullyQualifiedMethodName = swaggerInterface.getName() + "." + swaggerMethod.getName();
        if (swaggerMethod.isAnnotationPresent(Get.class)) {
            this.httpMethod = HttpMethod.GET;
            this.relativePath = swaggerMethod.getAnnotation(Get.class).value();
        } else if (swaggerMethod.isAnnotationPresent(Put.class)) {
            this.httpMethod = HttpMethod.PUT;
            this.relativePath = swaggerMethod.getAnnotation(Put.class).value();
        } else if (swaggerMethod.isAnnotationPresent(Head.class)) {
            this.httpMethod = HttpMethod.HEAD;
            this.relativePath = swaggerMethod.getAnnotation(Head.class).value();
        } else if (swaggerMethod.isAnnotationPresent(Delete.class)) {
            this.httpMethod = HttpMethod.DELETE;
            this.relativePath = swaggerMethod.getAnnotation(Delete.class).value();
        } else if (swaggerMethod.isAnnotationPresent(Post.class)) {
            this.httpMethod = HttpMethod.POST;
            this.relativePath = swaggerMethod.getAnnotation(Post.class).value();
        } else if (swaggerMethod.isAnnotationPresent(Patch.class)) {
            this.httpMethod = HttpMethod.PATCH;
            this.relativePath = swaggerMethod.getAnnotation(Patch.class).value();
        } else if (swaggerMethod.isAnnotationPresent(Options.class)) {
            this.httpMethod = HttpMethod.OPTIONS;
            this.relativePath = swaggerMethod.getAnnotation(Options.class).value();
        } else {
            throw new MissingRequiredAnnotationException(REQUIRED_HTTP_METHODS, swaggerMethod);
        }
        this.returnType = swaggerMethod.getGenericReturnType();
        ReturnValueWireType returnValueWireTypeAnnotation = swaggerMethod.getAnnotation(ReturnValueWireType.class);
        this.returnValueWireType = returnValueWireTypeAnnotation != null ? ((returnValueWireType = returnValueWireTypeAnnotation.value()) == Base64Url.class || returnValueWireType == DateTimeRfc1123.class ? returnValueWireType : (TypeUtil.isTypeOrSubTypeOf(returnValueWireType, List.class) ? returnValueWireType.getGenericInterfaces()[0] : (TypeUtil.isTypeOrSubTypeOf(returnValueWireType, Page.class) ? returnValueWireType : null))) : null;
        if (swaggerMethod.isAnnotationPresent(Headers.class)) {
            String[] stringArray;
            Headers headersAnnotation = swaggerMethod.getAnnotation(Headers.class);
            String[] stringArray2 = stringArray = headersAnnotation.value();
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String headerValue;
                Annotation[] headerName;
                String header = stringArray2[i];
                int colonIndex = header.indexOf(":");
                if (colonIndex < 0 || (headerName = header.substring(0, colonIndex).trim()).isEmpty() || (headerValue = header.substring(colonIndex + 1).trim()).isEmpty()) continue;
                if (headerValue.contains(",")) {
                    this.headers.set((String)headerName, Arrays.asList(headerValue.split(",")));
                    continue;
                }
                this.headers.set((String)headerName, headerValue);
            }
        }
        if ((expectedResponses = swaggerMethod.getAnnotation(ExpectedResponses.class)) != null && expectedResponses.value().length > 0) {
            this.expectedStatusCodes = new BitSet();
            for (int code : expectedResponses.value()) {
                this.expectedStatusCodes.set(code);
            }
        } else {
            this.expectedStatusCodes = null;
        }
        this.unexpectedResponseExceptionTypes = (UnexpectedResponseExceptionType[])swaggerMethod.getAnnotationsByType(UnexpectedResponseExceptionType.class);
        Object var6_9 = null;
        String bodyContentType = null;
        Object bodyJavaType = null;
        Annotation[][] allParametersAnnotations = swaggerMethod.getParameterAnnotations();
        for (int parameterIndex = 0; parameterIndex < allParametersAnnotations.length; ++parameterIndex) {
            Annotation[] parameterAnnotations;
            for (Annotation annotation : parameterAnnotations = swaggerMethod.getParameterAnnotations()[parameterIndex]) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType.equals(HostParam.class)) {
                    HostParam hostParamAnnotation = (HostParam)annotation;
                    this.hostSubstitutions.addAll(RangeReplaceSubstitution.getRangeReplaceSubstitutions(hostParamAnnotation.value(), parameterIndex, !hostParamAnnotation.encoded(), this.rawHost));
                    continue;
                }
                if (annotationType.equals(PathParam.class)) {
                    PathParam pathParamAnnotation = (PathParam)annotation;
                    this.pathSubstitutions.addAll(RangeReplaceSubstitution.getRangeReplaceSubstitutions(pathParamAnnotation.value(), parameterIndex, !pathParamAnnotation.encoded(), this.relativePath));
                    continue;
                }
                if (annotationType.equals(QueryParam.class)) {
                    QueryParam queryParamAnnotation = (QueryParam)annotation;
                    this.querySubstitutions.add(new QuerySubstitution(queryParamAnnotation.value(), parameterIndex, !queryParamAnnotation.encoded(), queryParamAnnotation.multipleQueryParams()));
                    continue;
                }
                if (annotationType.equals(HeaderParam.class)) {
                    HeaderParam headerParamAnnotation = (HeaderParam)annotation;
                    this.headerSubstitutions.add(new HeaderSubstitution(headerParamAnnotation.value(), parameterIndex, false));
                    continue;
                }
                if (annotationType.equals(BodyParam.class)) {
                    BodyParam bodyParamAnnotation = (BodyParam)annotation;
                    Integer n = parameterIndex;
                    bodyContentType = bodyParamAnnotation.value();
                    bodyJavaType = swaggerMethod.getGenericParameterTypes()[parameterIndex];
                    continue;
                }
                if (!annotationType.equals(FormParam.class)) continue;
                FormParam formParamAnnotation = (FormParam)annotation;
                this.formSubstitutions.add(new Substitution(formParamAnnotation.value(), parameterIndex, !formParamAnnotation.encoded()));
                bodyContentType = "application/x-www-form-urlencoded";
                bodyJavaType = String.class;
            }
        }
        this.hostSubstitutions.sort(RangeReplaceSubstitution::compareTo);
        this.pathSubstitutions.sort(RangeReplaceSubstitution::compareTo);
        this.bodyContentMethodParameterIndex = var6_10;
        this.bodyContentType = bodyContentType;
        this.bodyJavaType = bodyJavaType;
        boolean isReactiveMethod = this.isReactiveType(this.returnType);
        Class<?>[] parameterTypes = swaggerMethod.getParameterTypes();
        int contextPosition = -1;
        int requestOptionsPosition = -1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            if (parameterType == Context.class && contextPosition == -1) {
                contextPosition = i;
            } else if (parameterType == RequestOptions.class && requestOptionsPosition == -1) {
                requestOptionsPosition = i;
            }
            isReactiveMethod = isReactiveMethod || this.isReactiveType(parameterType);
        }
        this.isReactive = isReactiveMethod;
        if (isReactiveMethod) {
            Type reactiveTypeArgument = TypeUtil.getTypeArgument(this.returnType);
            this.isStreamResponse = this.isStreamResponseType(reactiveTypeArgument);
            this.headersEagerlyConverted = TypeUtil.isTypeOrSubTypeOf(ResponseBase.class, reactiveTypeArgument);
        } else {
            this.isStreamResponse = this.isStreamResponseType(this.returnType);
            this.headersEagerlyConverted = TypeUtil.isTypeOrSubTypeOf(ResponseBase.class, this.returnType);
        }
        this.contextPosition = contextPosition;
        this.requestOptionsPosition = requestOptionsPosition;
        Type unwrappedReturnType = SwaggerMethodParser.unwrapReturnType(this.returnType);
        this.returnTypeDecodeable = SwaggerMethodParser.isReturnTypeDecodeable(unwrappedReturnType);
        this.responseEagerlyRead = SwaggerMethodParser.isResponseEagerlyRead(unwrappedReturnType);
        this.ignoreResponseBody = SwaggerMethodParser.isResponseBodyIgnored(unwrappedReturnType);
        this.spanName = interfaceParser.getServiceName() + "." + swaggerMethod.getName();
    }

    public String getFullyQualifiedMethodName() {
        return this.fullyQualifiedMethodName;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setSchemeAndHost(Object[] swaggerMethodArguments, UrlBuilder urlBuilder, SerializerAdapter serializer) {
        SwaggerMethodParser.setSchemeAndHost(this.rawHost, this.hostSubstitutions, swaggerMethodArguments, urlBuilder, serializer);
    }

    static void setSchemeAndHost(String rawHost, List<RangeReplaceSubstitution> hostSubstitutions, Object[] swaggerMethodArguments, UrlBuilder urlBuilder, SerializerAdapter serializer) {
        String substitutedHost = SwaggerMethodParser.applySubstitutions(rawHost, hostSubstitutions, swaggerMethodArguments, serializer);
        int index = substitutedHost.indexOf("://");
        if (index == -1) {
            urlBuilder.setHost(substitutedHost);
        } else {
            urlBuilder.setScheme(substitutedHost.substring(0, index));
            String host = substitutedHost.substring(index + 3);
            if (!CoreUtils.isNullOrEmpty(host)) {
                urlBuilder.setHost(host);
            } else {
                urlBuilder.setHost(substitutedHost);
            }
        }
    }

    public String setPath(Object[] methodArguments, SerializerAdapter serializer) {
        return SwaggerMethodParser.applySubstitutions(this.relativePath, this.pathSubstitutions, methodArguments, serializer);
    }

    public void setEncodedQueryParameters(Object[] swaggerMethodArguments, UrlBuilder urlBuilder, SerializerAdapter serializer) {
        if (swaggerMethodArguments == null) {
            return;
        }
        for (QuerySubstitution substitution : this.querySubstitutions) {
            int parameterIndex = substitution.getMethodParameterIndex();
            if (0 > parameterIndex || parameterIndex >= swaggerMethodArguments.length) continue;
            Object methodArgument = swaggerMethodArguments[substitution.getMethodParameterIndex()];
            if (substitution.mergeParameters() && methodArgument instanceof List) {
                List methodArguments = (List)methodArgument;
                for (Object argument : methodArguments) {
                    SwaggerMethodParser.addSerializedQueryParameter(serializer, argument, substitution.shouldEncode(), urlBuilder, substitution.getUrlParameterName());
                }
                continue;
            }
            SwaggerMethodParser.addSerializedQueryParameter(serializer, methodArgument, substitution.shouldEncode(), urlBuilder, substitution.getUrlParameterName());
        }
    }

    public void setHeaders(Object[] swaggerMethodArguments, HttpHeaders httpHeaders, SerializerAdapter serializer) {
        httpHeaders.setAllHttpHeaders(this.headers);
        if (swaggerMethodArguments == null) {
            return;
        }
        for (HeaderSubstitution headerSubstitution : this.headerSubstitutions) {
            int parameterIndex = headerSubstitution.getMethodParameterIndex();
            if (0 > parameterIndex || parameterIndex >= swaggerMethodArguments.length) continue;
            Object methodArgument = swaggerMethodArguments[headerSubstitution.getMethodParameterIndex()];
            if (methodArgument instanceof Map) {
                Map headerCollection = (Map)methodArgument;
                String headerCollectionPrefix = headerSubstitution.getUrlParameterName();
                for (Map.Entry headerCollectionEntry : headerCollection.entrySet()) {
                    String headerName = headerCollectionPrefix + (String)headerCollectionEntry.getKey();
                    String headerValue = SwaggerMethodParser.serialize(serializer, headerCollectionEntry.getValue());
                    if (headerValue == null) continue;
                    httpHeaders.set(headerName, headerValue);
                }
                continue;
            }
            String headerValue = SwaggerMethodParser.serialize(serializer, methodArgument);
            if (headerValue == null) continue;
            httpHeaders.set(headerSubstitution.getHeaderName(), headerValue);
        }
    }

    public Context setContext(Object[] swaggerMethodArguments) {
        if (this.contextPosition < 0) {
            return Context.NONE;
        }
        Context context = (Context)swaggerMethodArguments[this.contextPosition];
        return context != null ? context : Context.NONE;
    }

    public RequestOptions setRequestOptions(Object[] swaggerMethodArguments) {
        return this.requestOptionsPosition < 0 ? null : (RequestOptions)swaggerMethodArguments[this.requestOptionsPosition];
    }

    @Override
    public boolean isExpectedResponseStatusCode(int statusCode) {
        return this.expectedStatusCodes == null ? statusCode < 400 : this.expectedStatusCodes.get(statusCode);
    }

    @Override
    public UnexpectedExceptionInformation getUnexpectedException(int code) {
        if (this.exceptionMapping == null) {
            this.exceptionMapping = this.processUnexpectedResponseExceptionTypes();
        }
        return this.exceptionMapping.getOrDefault(code, this.defaultException);
    }

    public Object setBody(Object[] swaggerMethodArguments, SerializerAdapter serializer) {
        Object result = null;
        if (this.bodyContentMethodParameterIndex != null && swaggerMethodArguments != null && 0 <= this.bodyContentMethodParameterIndex && this.bodyContentMethodParameterIndex < swaggerMethodArguments.length) {
            result = swaggerMethodArguments[this.bodyContentMethodParameterIndex];
        }
        if (!CoreUtils.isNullOrEmpty(this.formSubstitutions) && swaggerMethodArguments != null) {
            result = this.formSubstitutions.stream().map(substitution -> SwaggerMethodParser.serializeFormData(serializer, substitution.getUrlParameterName(), swaggerMethodArguments[substitution.getMethodParameterIndex()], substitution.shouldEncode())).filter(Objects::nonNull).collect(Collectors.joining("&"));
        }
        return result;
    }

    public String getBodyContentType() {
        return this.bodyContentType;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    public Type getBodyJavaType() {
        return this.bodyJavaType;
    }

    @Override
    public Type getReturnValueWireType() {
        return this.returnValueWireType;
    }

    private static void addSerializedQueryParameter(SerializerAdapter adapter, Object value, boolean shouldEncode, UrlBuilder urlBuilder, String parameterName) {
        String parameterValue = SwaggerMethodParser.serialize(adapter, value);
        if (parameterValue != null) {
            if (shouldEncode) {
                parameterValue = UrlEscapers.QUERY_ESCAPER.escape(parameterValue);
            }
            urlBuilder.addQueryParameter(parameterName, parameterValue);
        }
    }

    private static String serialize(SerializerAdapter serializer, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value.getClass().isPrimitive() || value instanceof Number || value instanceof Boolean || value instanceof Character || value instanceof DateTimeRfc1123) {
            return String.valueOf(value);
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).format(DateTimeFormatter.ISO_INSTANT);
        }
        if (value instanceof ExpandableStringEnum || value.getClass().isEnum()) {
            String stringValue = value.toString();
            return stringValue == null ? "null" : stringValue;
        }
        return serializer.serializeRaw(value);
    }

    private static String serializeFormData(SerializerAdapter serializer, String key, Object value, boolean shouldEncode) {
        if (value == null) {
            return null;
        }
        String encodedKey = UrlEscapers.FORM_ESCAPER.escape(key);
        if (value instanceof List) {
            return ((List)value).stream().map(element -> SwaggerMethodParser.serializeAndEncodeFormValue(serializer, element, shouldEncode)).filter(Objects::nonNull).map(formValue -> encodedKey + "=" + formValue).collect(Collectors.joining("&"));
        }
        return encodedKey + "=" + SwaggerMethodParser.serializeAndEncodeFormValue(serializer, value, shouldEncode);
    }

    private static String serializeAndEncodeFormValue(SerializerAdapter serializer, Object value, boolean shouldEncode) {
        if (value == null) {
            return null;
        }
        String serializedValue = SwaggerMethodParser.serialize(serializer, value);
        return shouldEncode ? UrlEscapers.FORM_ESCAPER.escape(serializedValue) : serializedValue;
    }

    private static String applySubstitutions(String originalValue, List<RangeReplaceSubstitution> substitutions, Object[] methodArguments, SerializerAdapter serializer) {
        int originalSize;
        if (methodArguments == null || CoreUtils.isNullOrEmpty(substitutions)) {
            return originalValue;
        }
        int substitutionSize = originalSize = originalValue.length();
        ArrayList<AbstractMap.SimpleEntry<RangeReplaceSubstitution, String>> replacements = new ArrayList<AbstractMap.SimpleEntry<RangeReplaceSubstitution, String>>(substitutions.size());
        for (RangeReplaceSubstitution substitution : substitutions) {
            int substitutionParameterIndex = substitution.getMethodParameterIndex();
            if (substitutionParameterIndex < 0 || substitutionParameterIndex >= methodArguments.length) continue;
            Object object = methodArguments[substitutionParameterIndex];
            String substitutionValue = SwaggerMethodParser.serialize(serializer, object);
            if (substitutionValue != null && !substitutionValue.isEmpty() && substitution.shouldEncode()) {
                substitutionValue = UrlEscapers.PATH_ESCAPER.escape(substitutionValue);
            }
            if (substitutionValue == null) {
                substitutionValue = "";
            }
            substitutionSize += substitutionValue.length() - substitution.getSize();
            replacements.add(new AbstractMap.SimpleEntry<RangeReplaceSubstitution, String>(substitution, substitutionValue));
        }
        int last = 0;
        StringBuilder builder = new StringBuilder(substitutionSize);
        for (Map.Entry entry : replacements) {
            if (last < ((RangeReplaceSubstitution)entry.getKey()).getStart()) {
                builder.append(originalValue, last, ((RangeReplaceSubstitution)entry.getKey()).getStart());
            }
            builder.append((String)entry.getValue());
            last = ((RangeReplaceSubstitution)entry.getKey()).getEnd();
        }
        if (last < originalSize) {
            builder.append(originalValue, last, originalSize);
        }
        return builder.toString();
    }

    private Map<Integer, UnexpectedExceptionInformation> processUnexpectedResponseExceptionTypes() {
        HashMap<Integer, UnexpectedExceptionInformation> exceptionHashMap = new HashMap<Integer, UnexpectedExceptionInformation>();
        for (UnexpectedResponseExceptionType exceptionAnnotation : this.unexpectedResponseExceptionTypes) {
            UnexpectedExceptionInformation exception = new UnexpectedExceptionInformation(exceptionAnnotation.value());
            if (exceptionAnnotation.code().length == 0) {
                this.defaultException = exception;
                continue;
            }
            for (int statusCode : exceptionAnnotation.code()) {
                exceptionHashMap.put(statusCode, exception);
            }
        }
        if (this.defaultException == null) {
            this.defaultException = new UnexpectedExceptionInformation(HttpResponseException.class);
        }
        return exceptionHashMap;
    }

    public boolean isReactive() {
        return this.isReactive;
    }

    boolean isReactiveType(Type type) {
        return TypeUtil.isTypeOrSubTypeOf(type, Mono.class) || TypeUtil.isTypeOrSubTypeOf(type, Flux.class) || TypeUtil.isTypeOrSubTypeOf(type, Publisher.class);
    }

    boolean isStreamResponseType(Type type) {
        return TypeUtil.getRawClass(type).equals(StreamResponse.class);
    }

    public boolean isStreamResponse() {
        return this.isStreamResponse;
    }

    @Override
    public boolean isReturnTypeDecodeable() {
        return this.returnTypeDecodeable;
    }

    @Override
    public boolean isResponseEagerlyRead() {
        return this.responseEagerlyRead;
    }

    @Override
    public boolean isResponseBodyIgnored() {
        return this.ignoreResponseBody;
    }

    @Override
    public boolean isHeadersEagerlyConverted() {
        return this.headersEagerlyConverted;
    }

    public String getSpanName() {
        return this.spanName;
    }

    public static boolean isReturnTypeDecodeable(Type unwrappedReturnType) {
        if (unwrappedReturnType == null) {
            return false;
        }
        return !TypeUtil.isTypeOrSubTypeOf(unwrappedReturnType, BinaryData.class) && !TypeUtil.isTypeOrSubTypeOf(unwrappedReturnType, byte[].class) && !TypeUtil.isTypeOrSubTypeOf(unwrappedReturnType, ByteBuffer.class) && !TypeUtil.isTypeOrSubTypeOf(unwrappedReturnType, InputStream.class) && !TypeUtil.isTypeOrSubTypeOf(unwrappedReturnType, Void.TYPE) && !TypeUtil.isTypeOrSubTypeOf(unwrappedReturnType, Void.class);
    }

    public static boolean isResponseBodyIgnored(Type unwrappedReturnType) {
        if (unwrappedReturnType == null) {
            return false;
        }
        return TypeUtil.isTypeOrSubTypeOf(unwrappedReturnType, Void.TYPE) || TypeUtil.isTypeOrSubTypeOf(unwrappedReturnType, Void.class);
    }

    public static boolean isResponseEagerlyRead(Type unwrappedReturnType) {
        if (unwrappedReturnType == null) {
            return false;
        }
        return SwaggerMethodParser.isReturnTypeDecodeable(unwrappedReturnType);
    }

    public static Type unwrapReturnType(Type returnType) {
        if (returnType == null) {
            return null;
        }
        if (TypeUtil.isTypeOrSubTypeOf(returnType, ResponseBase.class)) {
            returnType = SwaggerMethodParser.walkSuperTypesUntil(returnType, type -> TypeUtil.getRawClass(type) == ResponseBase.class);
            return SwaggerMethodParser.unwrapReturnType(TypeUtil.getTypeArguments(returnType)[1]);
        }
        if (TypeUtil.isTypeOrSubTypeOf(returnType, Response.class)) {
            returnType = SwaggerMethodParser.walkSuperTypesUntil(returnType, type -> TypeUtil.typeImplementsInterface(type, Response.class));
            return SwaggerMethodParser.unwrapReturnType(TypeUtil.getTypeArgument(returnType));
        }
        if (TypeUtil.isTypeOrSubTypeOf(returnType, Mono.class)) {
            returnType = SwaggerMethodParser.walkSuperTypesUntil(returnType, type -> TypeUtil.getRawClass(type) == Mono.class);
            return SwaggerMethodParser.unwrapReturnType(TypeUtil.getTypeArgument(returnType));
        }
        if (TypeUtil.isTypeOrSubTypeOf(returnType, Flux.class)) {
            returnType = SwaggerMethodParser.walkSuperTypesUntil(returnType, type -> TypeUtil.getRawClass(type) == Flux.class);
            return SwaggerMethodParser.unwrapReturnType(TypeUtil.getTypeArgument(returnType));
        }
        return returnType;
    }

    private static Type walkSuperTypesUntil(Type type, Predicate<Type> untilChecker) {
        while (!untilChecker.test(type)) {
            type = TypeUtil.getSuperType(type);
        }
        return type;
    }
}

