/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.transport;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.client.Connection;
import org.eclipse.jetty.client.transport.HttpDestination;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.HTTP2ClientConnectionFactory;
import org.eclipse.jetty.http2.client.transport.internal.HTTPSessionListenerPromise;
import org.eclipse.jetty.http2.client.transport.internal.HttpConnectionOverHTTP2;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.Transport;
import org.eclipse.jetty.io.ssl.SslClientConnectionFactory;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public class ClientConnectionFactoryOverHTTP2
extends ContainerLifeCycle
implements ClientConnectionFactory {
    private final ClientConnectionFactory factory = new HTTP2ClientConnectionFactory();
    private final HTTP2Client http2Client;

    public ClientConnectionFactoryOverHTTP2(HTTP2Client http2Client) {
        this.http2Client = http2Client;
        this.installBean(http2Client);
    }

    public org.eclipse.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HTTPSessionListenerPromise listenerPromise = new HTTPSessionListenerPromise(context);
        context.put("org.eclipse.jetty.client.http2", this.http2Client);
        context.put("org.eclipse.jetty.client.http2.sessionListener", listenerPromise);
        context.put("org.eclipse.jetty.client.http2.sessionPromise", listenerPromise);
        return this.factory.newConnection(endPoint, context);
    }

    public static class HTTP2
    extends ClientConnectionFactory.Info {
        private static final List<String> protocols = List.of("h2", "h2c");
        private static final List<String> h2c = List.of("h2c");

        public HTTP2(HTTP2Client http2Client) {
            super((ClientConnectionFactory)new ClientConnectionFactoryOverHTTP2(http2Client));
        }

        public List<String> getProtocols(boolean secure) {
            return secure ? protocols : h2c;
        }

        public Transport newTransport() {
            return Transport.TCP_IP;
        }

        public void upgrade(EndPoint endPoint, final Map<String, Object> context) {
            final HttpDestination destination = (HttpDestination)context.get("org.eclipse.jetty.client.destination");
            final Promise promise = (Promise)context.get("org.eclipse.jetty.client.connection.promise");
            context.put("org.eclipse.jetty.client.connection.promise", new Promise<HttpConnectionOverHTTP2>(){
                final /* synthetic */ HTTP2 this$0;
                {
                    this.this$0 = this$0;
                }

                public void succeeded(HttpConnectionOverHTTP2 connection) {
                    promise.succeeded((Object)connection);
                    connection.upgrade(context);
                    destination.accept((Connection)connection);
                }

                public void failed(Throwable x) {
                    promise.failed(x);
                }
            });
            this.upgrade(destination.getClientConnectionFactory(), endPoint, context);
        }

        private void upgrade(ClientConnectionFactory factory, EndPoint endPoint, Map<String, Object> context) {
            try {
                if (factory instanceof SslClientConnectionFactory) {
                    SslClientConnectionFactory sslFactory = (SslClientConnectionFactory)factory;
                    if (endPoint instanceof SslConnection.SslEndPoint) {
                        factory = sslFactory.getClientConnectionFactory();
                    }
                }
                org.eclipse.jetty.io.Connection newConnection = factory.newConnection(endPoint, context);
                endPoint.upgrade(newConnection);
            }
            catch (IOException x) {
                throw new UncheckedIOException(x);
            }
        }

        public String toString() {
            return String.format("%s@%x%s", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), protocols);
        }
    }
}

