/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem.s3;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Publisher;

public abstract class S3AsyncClientWrapper
implements S3AsyncClient {
    private final S3AsyncClient delegate;

    public S3AsyncClientWrapper(S3AsyncClient delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    public String serviceName() {
        return this.delegate.serviceName();
    }

    public CompletableFuture<PutObjectResponse> putObject(PutObjectRequest request, AsyncRequestBody body) {
        CompletableFuture future = this.delegate.putObject(request, body);
        this.handle(RequestType.PUT_OBJECT, future);
        return future;
    }

    public CompletableFuture<DeleteObjectsResponse> deleteObjects(DeleteObjectsRequest request) {
        CompletableFuture future = this.delegate.deleteObjects(request);
        this.handle(RequestType.DELETE_OBJECTS, future);
        return future;
    }

    public <T> CompletableFuture<T> getObject(GetObjectRequest request, AsyncResponseTransformer<GetObjectResponse, T> transformer) {
        CompletableFuture future = this.delegate.getObject(request, transformer);
        this.handle(RequestType.GET_OBJECT, future);
        return future;
    }

    public CompletableFuture<CreateMultipartUploadResponse> createMultipartUpload(CreateMultipartUploadRequest request) {
        CompletableFuture future = this.delegate.createMultipartUpload(request);
        this.handle(RequestType.CREATE_MULTIPART_UPLOAD, future);
        return future;
    }

    public CompletableFuture<UploadPartResponse> uploadPart(UploadPartRequest request, AsyncRequestBody body) {
        CompletableFuture future = this.delegate.uploadPart(request, body);
        this.handle(RequestType.UPLOAD_PART, future);
        return future;
    }

    public CompletableFuture<CompleteMultipartUploadResponse> completeMultipartUpload(CompleteMultipartUploadRequest request) {
        CompletableFuture future = this.delegate.completeMultipartUpload(request);
        this.handle(RequestType.COMPLETE_MULTIPART_UPLOAD, future);
        return future;
    }

    public CompletableFuture<AbortMultipartUploadResponse> abortMultipartUpload(AbortMultipartUploadRequest request) {
        CompletableFuture future = this.delegate.abortMultipartUpload(request);
        this.handle(RequestType.ABORT_MULTIPART_UPLOAD, future);
        return future;
    }

    public CompletableFuture<ListObjectsV2Response> listObjectsV2(ListObjectsV2Request request) {
        CompletableFuture future = this.delegate.listObjectsV2(request);
        this.handle(RequestType.LIST_OBJECTS_V2, future);
        return future;
    }

    protected abstract void handle(RequestType var1, CompletableFuture<?> var2);

    public ListObjectsV2Publisher listObjectsV2Paginator(ListObjectsV2Request listObjectsV2Request) {
        return new ListObjectsV2Publisher((S3AsyncClient)this, this.applyPaginatorUserAgent(listObjectsV2Request));
    }

    private <T extends S3Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("2.26.8").name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElseGet(() -> ((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((S3Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build());
    }

    public void close() {
        this.delegate.close();
    }

    public static enum RequestType {
        PUT_OBJECT,
        DELETE_OBJECTS,
        GET_OBJECT,
        CREATE_MULTIPART_UPLOAD,
        UPLOAD_PART,
        COMPLETE_MULTIPART_UPLOAD,
        ABORT_MULTIPART_UPLOAD,
        LIST_OBJECTS_V2;

    }
}

