/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import io.trino.hadoop.;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.impl.AbstractFSBuilderImpl;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class FSDataOutputStreamBuilder<S extends FSDataOutputStream, B extends FSDataOutputStreamBuilder<S, B>>
extends AbstractFSBuilderImpl<S, B> {
    private final FileSystem fs;
    private FsPermission permission = null;
    private int bufferSize;
    private short replication;
    private long blockSize;
    private boolean recursive = false;
    private final EnumSet<CreateFlag> flags = EnumSet.noneOf(CreateFlag.class);
    private Progressable progress = null;
    private Options.ChecksumOpt checksumOpt = null;

    @Override
    public abstract B getThisBuilder();

    FSDataOutputStreamBuilder(@.Nonnull FileContext fc, @.Nonnull Path p) throws IOException {
        super(Preconditions.checkNotNull(p));
        Preconditions.checkNotNull(fc);
        this.fs = null;
        AbstractFileSystem afs = fc.getFSofPath(p);
        FsServerDefaults defaults = afs.getServerDefaults(p);
        this.bufferSize = defaults.getFileBufferSize();
        this.replication = defaults.getReplication();
        this.blockSize = defaults.getBlockSize();
    }

    protected FSDataOutputStreamBuilder(@.Nonnull FileSystem fileSystem, @.Nonnull Path p) {
        super(Preconditions.checkNotNull(p));
        Preconditions.checkNotNull(fileSystem);
        this.fs = fileSystem;
        this.bufferSize = this.fs.getConf().getInt("io.file.buffer.size", 4096);
        this.replication = this.fs.getDefaultReplication(p);
        this.blockSize = this.fs.getDefaultBlockSize(p);
    }

    protected FileSystem getFS() {
        Preconditions.checkNotNull(this.fs);
        return this.fs;
    }

    protected FsPermission getPermission() {
        if (this.permission == null) {
            this.permission = FsPermission.getFileDefault();
        }
        return this.permission;
    }

    public B permission(@.Nonnull FsPermission perm) {
        Preconditions.checkNotNull(perm);
        this.permission = perm;
        return (B)this.getThisBuilder();
    }

    protected int getBufferSize() {
        return this.bufferSize;
    }

    public B bufferSize(int bufSize) {
        this.bufferSize = bufSize;
        return (B)this.getThisBuilder();
    }

    protected short getReplication() {
        return this.replication;
    }

    public B replication(short replica) {
        this.replication = replica;
        return (B)this.getThisBuilder();
    }

    protected long getBlockSize() {
        return this.blockSize;
    }

    public B blockSize(long blkSize) {
        this.blockSize = blkSize;
        return (B)this.getThisBuilder();
    }

    protected boolean isRecursive() {
        return this.recursive;
    }

    public B recursive() {
        this.recursive = true;
        return (B)this.getThisBuilder();
    }

    protected Progressable getProgress() {
        return this.progress;
    }

    public B progress(@.Nonnull Progressable prog) {
        Preconditions.checkNotNull(prog);
        this.progress = prog;
        return (B)this.getThisBuilder();
    }

    protected EnumSet<CreateFlag> getFlags() {
        return this.flags;
    }

    public B create() {
        this.flags.add(CreateFlag.CREATE);
        return (B)this.getThisBuilder();
    }

    public B overwrite(boolean overwrite) {
        if (overwrite) {
            this.flags.add(CreateFlag.OVERWRITE);
        } else {
            this.flags.remove((Object)CreateFlag.OVERWRITE);
        }
        return (B)this.getThisBuilder();
    }

    public B append() {
        this.flags.add(CreateFlag.APPEND);
        return (B)this.getThisBuilder();
    }

    protected Options.ChecksumOpt getChecksumOpt() {
        return this.checksumOpt;
    }

    public B checksumOpt(@.Nonnull Options.ChecksumOpt chksumOpt) {
        Preconditions.checkNotNull(chksumOpt);
        this.checksumOpt = chksumOpt;
        return (B)this.getThisBuilder();
    }

    @Override
    public abstract S build() throws IllegalArgumentException, IOException;
}

