/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.concurrent;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class ExecutorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorHelper.class);

    static void logThrowableFromAfterExecute(Runnable r, Throwable t) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("afterExecute in thread: " + Thread.currentThread().getName() + ", runnable type: " + r.getClass().getName());
        }
        if (t == null && r instanceof Future && ((Future)((Object)r)).isDone()) {
            try {
                ((Future)((Object)r)).get();
            }
            catch (ExecutionException ee) {
                LOG.debug("Execution exception when running task in {}", (Object)Thread.currentThread().getName());
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                LOG.debug("Thread ( {} ) interrupted: ", (Object)Thread.currentThread(), (Object)ie);
                Thread.currentThread().interrupt();
            }
            catch (Throwable throwable) {
                t = throwable;
            }
        }
        if (t != null) {
            LOG.warn("Caught exception in thread {}  + : ", (Object)Thread.currentThread().getName(), (Object)t);
        }
    }

    private ExecutorHelper() {
    }
}

