/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.hdfs;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeConfig;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeManager;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeStats;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeStorage;
import io.trino.plugin.exchange.hdfs.ExchangeHdfsConfig;
import io.trino.plugin.exchange.hdfs.HadoopFileSystemExchangeStorage;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.net.URI;
import java.util.List;
import org.weakref.jmx.guice.ExportBinder;

public class HdfsExchangeModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.bind(FileSystemExchangeStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(FileSystemExchangeStats.class).withGeneratedName();
        binder.bind(FileSystemExchangeManager.class).in(Scopes.SINGLETON);
        List baseDirectories = ((FileSystemExchangeConfig)this.buildConfigObject(FileSystemExchangeConfig.class)).getBaseDirectories();
        if (baseDirectories.stream().map(URI::getScheme).distinct().count() != 1L) {
            binder.addError((Throwable)new TrinoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_INVALID, "Multiple schemes in exchange base directories"));
            return;
        }
        String scheme = ((URI)baseDirectories.get(0)).getScheme();
        boolean skipDirectorySchemeValidation = ((ExchangeHdfsConfig)this.buildConfigObject(ExchangeHdfsConfig.class)).isSkipDirectorySchemeValidation();
        if (scheme.equalsIgnoreCase("hdfs") || skipDirectorySchemeValidation) {
            binder.bind(FileSystemExchangeStorage.class).to(HadoopFileSystemExchangeStorage.class).in(Scopes.SINGLETON);
        } else {
            binder.addError((Throwable)new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Scheme %s is not supported as exchange spooling storage in exchange manager type %s", scheme, "hdfs")));
        }
    }
}

