/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class Options
extends AbstractProvider<BaseProviders> {
    protected Options(BaseProviders faker) {
        super(faker);
    }

    @SafeVarargs
    public final <E> E option(E ... options) {
        return options[((BaseProviders)this.faker).random().nextInt(options.length)];
    }

    public final char option(char[] options) {
        return options[((BaseProviders)this.faker).random().nextInt(options.length)];
    }

    public final int option(int[] options) {
        return options[((BaseProviders)this.faker).random().nextInt(options.length)];
    }

    public final long option(long[] options) {
        return options[((BaseProviders)this.faker).random().nextInt(options.length)];
    }

    public final float option(float[] options) {
        return options[((BaseProviders)this.faker).random().nextInt(options.length)];
    }

    public final double option(double[] options) {
        return options[((BaseProviders)this.faker).random().nextInt(options.length)];
    }

    public final short option(short[] options) {
        return options[((BaseProviders)this.faker).random().nextInt(options.length)];
    }

    public final boolean option(boolean[] options) {
        return options[((BaseProviders)this.faker).random().nextInt(options.length)];
    }

    public final byte option(byte[] options) {
        return options[((BaseProviders)this.faker).random().nextInt(options.length)];
    }

    public final <E> Set<E> subset(int size, E ... options) {
        if (size < 0) {
            throw new IllegalArgumentException("size should be not negative: " + size);
        }
        if (size == 0) {
            return Collections.emptySet();
        }
        List opts = Stream.of(options).distinct().collect(Collectors.toList());
        if (size >= opts.size()) {
            return new HashSet(opts);
        }
        HashSet set = new HashSet();
        for (int i = 0; i < size; ++i) {
            int randomIndex = ((BaseProviders)this.faker).random().nextInt(opts.size());
            set.add(opts.get(randomIndex));
            opts.remove(randomIndex);
        }
        return set;
    }

    public String option(String ... options) {
        return options[((BaseProviders)this.faker).random().nextInt(options.length)];
    }

    public final Set<String> subset(int size, String ... options) {
        if (size < 0) {
            throw new IllegalArgumentException("size should be not negative: " + size);
        }
        if (size == 0) {
            return Collections.emptySet();
        }
        List opts = Stream.of(options).distinct().collect(Collectors.toList());
        if (size >= opts.size()) {
            return new HashSet<String>(opts);
        }
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            int randomIndex = ((BaseProviders)this.faker).random().nextInt(opts.size());
            set.add((String)opts.get(randomIndex));
            opts.remove(randomIndex);
        }
        return set;
    }

    public <E extends Enum<E>> E option(Class<E> enumeration) {
        Enum[] enumConstants = (Enum[])enumeration.getEnumConstants();
        return (E)enumConstants[((BaseProviders)this.faker).random().nextInt(enumConstants.length)];
    }

    public <E> E nextElement(E[] array) {
        return array[((BaseProviders)this.faker).random().nextInt(array.length)];
    }

    public <E> E nextElement(List<E> list) {
        return list.get(((BaseProviders)this.faker).random().nextInt(list.size()));
    }
}

