/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.service;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.datafaker.internal.helper.CopyOnWriteMap;
import net.datafaker.internal.helper.JavaNames;
import net.datafaker.internal.helper.SingletonLocale;
import net.datafaker.internal.helper.WordUtils;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseFaker;
import net.datafaker.providers.base.ObjectMethods;
import net.datafaker.providers.base.ProviderRegistration;
import net.datafaker.service.FakeValues;
import net.datafaker.service.FakeValuesContext;
import net.datafaker.service.FakeValuesGrouping;
import net.datafaker.service.FakeValuesInterface;
import net.datafaker.service.FakerContext;
import net.datafaker.shaded.curiousoddman.rgxgen.RgxGen;
import net.datafaker.transformations.CsvTransformer;
import net.datafaker.transformations.Field;
import net.datafaker.transformations.JsonTransformer;
import net.datafaker.transformations.Schema;
import net.datafaker.transformations.SimpleField;

public class FakeValuesService {
    private static final Class<?>[] PRIMITIVES = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static final char[] DIGITS = "0123456789".toCharArray();
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final Logger LOG = Logger.getLogger(FakeValuesService.class.getName());
    public static final Supplier<Map<String, Object>> MAP_STRING_OBJECT_SUPPLIER = () -> new CopyOnWriteMap(() -> new WeakHashMap());
    public static final Supplier<Map<String, String>> MAP_STRING_STRING_SUPPLIER = () -> new CopyOnWriteMap(() -> new WeakHashMap());
    private final Map<SingletonLocale, FakeValuesInterface> fakeValuesInterfaceMap = new CopyOnWriteMap<SingletonLocale, FakeValuesInterface>(IdentityHashMap::new);
    public static final SingletonLocale DEFAULT_LOCALE = SingletonLocale.get(Locale.ENGLISH);
    private static final Map<Class<?>, Map<String, Collection<Method>>> CLASS_2_METHODS_CACHE = new CopyOnWriteMap(IdentityHashMap::new);
    private static final Map<Class<?>, Constructor<?>> CLASS_2_CONSTRUCTOR_CACHE = new CopyOnWriteMap(IdentityHashMap::new);
    private static final JsonTransformer<Object> JSON_TRANSFORMER = JsonTransformer.builder().build();
    private final Map<String, RgxGen> expression2generex = new CopyOnWriteMap<String, RgxGen>(WeakHashMap::new);
    private final CopyOnWriteMap<SingletonLocale, Map<String, String>> key2Expression = new CopyOnWriteMap(IdentityHashMap::new);
    private static final Map<String, String[]> ARGS_2_SPLITTED_ARGS = new CopyOnWriteMap<String, String[]>(WeakHashMap::new);
    private static final Map<String, String[]> KEY_2_SPLITTED_KEY = new CopyOnWriteMap<String, String[]>(WeakHashMap::new);
    private final CopyOnWriteMap<SingletonLocale, Map<String, Object>> key2fetchedObject = new CopyOnWriteMap(IdentityHashMap::new);
    private static final Map<String, String> NAME_2_YAML = new CopyOnWriteMap<String, String>(WeakHashMap::new);
    private static final Map<String, String> REMOVED_UNDERSCORE = new CopyOnWriteMap<String, String>(WeakHashMap::new);
    private static final Map<Class<?>, Map<String, Map<String[], MethodAndCoercedArgs>>> MAP_OF_METHOD_AND_COERCED_ARGS = new CopyOnWriteMap(IdentityHashMap::new);
    private static final Map<String, String[]> EXPRESSION_2_SPLITTED = new CopyOnWriteMap<String, String[]>(WeakHashMap::new);
    private final Map<RegExpContext, ValueResolver> REGEXP2SUPPLIER_MAP = new CopyOnWriteMap<RegExpContext, ValueResolver>(HashMap::new);
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_MAP = new IdentityHashMap();
    private static final ConstantResolver EMPTY_STRING;
    private static final ConstantResolver NULL_VALUE;

    public void updateFakeValuesInterfaceMap(List<SingletonLocale> locales) {
        for (SingletonLocale l : locales) {
            this.fakeValuesInterfaceMap.computeIfAbsent(l, this::getCachedFakeValue);
        }
    }

    private FakeValuesInterface getCachedFakeValue(SingletonLocale locale) {
        if (DEFAULT_LOCALE == locale) {
            return FakeValuesGrouping.getEnglishFakeValueGrouping();
        }
        return FakeValues.of(FakeValuesContext.of(locale.getLocale()));
    }

    public void addPath(Locale locale, Path path) {
        Objects.requireNonNull(locale);
        if (path == null || Files.notExists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0]) || !Files.isReadable(path)) {
            throw new IllegalArgumentException("Path should be an existing readable file: \"%s\"".formatted(path));
        }
        try {
            this.addUrl(locale, path.toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Failed to read \"%s\"".formatted(path), e);
        }
    }

    public void addUrl(Locale locale, URL url) {
        Objects.requireNonNull(locale);
        if (url == null) {
            throw new IllegalArgumentException("url should be an existing readable file");
        }
        FakeValues fakeValues = FakeValues.of(FakeValuesContext.of(locale, url));
        SingletonLocale sLocale = SingletonLocale.get(locale);
        this.fakeValuesInterfaceMap.merge(sLocale, fakeValues, (prevValue, newValue) -> {
            FakeValuesGrouping fvg = new FakeValuesGrouping();
            fvg.add((FakeValuesInterface)prevValue);
            fvg.add((FakeValuesInterface)newValue);
            return fvg;
        });
    }

    public Object fetch(String key, FakerContext context) {
        List valuesArray = null;
        Object o = this.fetchObject(key, context);
        if (o instanceof List) {
            valuesArray = (List)o;
            int size = valuesArray.size();
            if (size == 0) {
                return null;
            }
            if (size == 1) {
                return valuesArray.get(0);
            }
        }
        return valuesArray == null ? null : valuesArray.get(context.getRandomService().nextInt(valuesArray.size()));
    }

    public String fetchString(String key, FakerContext context) {
        return (String)this.fetch(key, context);
    }

    public String safeFetch(String key, FakerContext context, String defaultIfNull) {
        Object o = this.fetchObject(key, context);
        if (o == null) {
            return defaultIfNull;
        }
        if (o instanceof List) {
            List values = (List)o;
            int size = values.size();
            return switch (size) {
                case 0 -> defaultIfNull;
                case 1 -> (String)values.get(0);
                default -> (String)values.get(context.getRandomService().nextInt(size));
            };
        }
        String str = o.toString();
        if (this.isSlashDelimitedRegex(str)) {
            return "#{regexify '%s'}".formatted(this.trimRegexSlashes(str));
        }
        return (String)o;
    }

    public <T> T fetchObject(String key, FakerContext context) {
        Object result = null;
        List<SingletonLocale> localeChain = context.getLocaleChain();
        boolean hasMoreThanOneLocales = localeChain.size() > 1;
        for (SingletonLocale sLocale : localeChain) {
            Object stringObjectMap;
            if (sLocale == DEFAULT_LOCALE && hasMoreThanOneLocales || (stringObjectMap = this.key2fetchedObject.get(sLocale)) == null || (result = stringObjectMap.get(key)) == null) continue;
            return (T)result;
        }
        String[] path = this.split(key);
        SingletonLocale local2Add = null;
        path[0] = path[0].toLowerCase(Locale.ROOT);
        for (SingletonLocale sLocale : localeChain) {
            Object currentValue = this.fakeValuesInterfaceMap.get(sLocale);
            for (int p = 0; currentValue != null && p < path.length; ++p) {
                String currentPath = path[p];
                currentValue = currentValue instanceof Map ? ((Map)currentValue).get(currentPath) : currentValue.get(currentPath);
            }
            result = currentValue;
            if (result == null) continue;
            local2Add = sLocale;
            break;
        }
        if (local2Add != null) {
            Object valueToCache = result;
            Object curResult = this.key2fetchedObject.getOrDefault(local2Add, Collections.emptyMap()).get(key);
            if (curResult != null) {
                return (T)result;
            }
            this.key2fetchedObject.computeIfAbsent(local2Add, __ -> MAP_STRING_OBJECT_SUPPLIER.get()).computeIfAbsent(key, __ -> valueToCache);
        }
        if (result instanceof List) {
            String itemStr;
            int itemStrLength;
            Object item;
            List list = (List)result;
            for (int i = 0; i < list.size() && (item = list.get(i)) instanceof String && (itemStrLength = (itemStr = (String)item).length()) >= 2; ++i) {
                int j = 0;
                StringBuilder sb = null;
                int start = 0;
                while (j < itemStrLength) {
                    char c;
                    while (j < itemStrLength - 2 && (itemStr.charAt(j) != '#' || itemStr.charAt(j + 1) != '{')) {
                        ++j;
                    }
                    int startWord = j + 2;
                    boolean letterOrDigitOnly = true;
                    for (j = startWord; j < itemStrLength && (c = itemStr.charAt(j)) != '}'; ++j) {
                        letterOrDigitOnly &= Character.isLetter(c) || Character.isDigit(c) || c == '_';
                    }
                    if (start >= itemStrLength || startWord >= itemStrLength || !letterOrDigitOnly) continue;
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    sb.append(itemStr, start, startWord);
                    sb.append(WordUtils.capitalize(path[0])).append(".").append(JavaNames.toJavaNames(itemStr.substring(startWord, j), true)).append("}");
                    start = j + 1;
                }
                if (sb == null) continue;
                if (start < itemStrLength) {
                    sb.append(itemStr, start, itemStrLength);
                }
                list.set(i, sb.toString());
            }
        }
        return (T)result;
    }

    private String[] split(String string) {
        return KEY_2_SPLITTED_KEY.computeIfAbsent(string, __ -> {
            int size = 0;
            int splitChar = 46;
            int length = string.length();
            for (int i = 0; i < length; ++i) {
                if (string.charAt(i) != '.') continue;
                ++size;
            }
            String[] result = new String[size + 1];
            char[] chars = string.toCharArray();
            int start = 0;
            int j = 0;
            for (int i = 0; i < length; ++i) {
                if (string.charAt(i) != '.') continue;
                if (i - start > 0) {
                    result[j++] = String.valueOf(chars, start, i - start);
                }
                start = i + 1;
            }
            result[j] = String.valueOf(chars, start, chars.length - start);
            return result;
        });
    }

    public String numerify(String numberString, FakerContext context) {
        return this.bothify(numberString, context, false, true, false);
    }

    public String bothify(String string, FakerContext context) {
        return this.bothify(string, context, false);
    }

    public String bothify(String input, FakerContext context, boolean isUpper) {
        return this.bothify(input, context, isUpper, true, true);
    }

    private String bothify(String input, FakerContext context, boolean isUpper, boolean numerify, boolean letterify) {
        int baseChar = isUpper ? 65 : 97;
        char[] res = input.toCharArray();
        block5: for (int i = 0; i < res.length; ++i) {
            switch (res[i]) {
                case '#': {
                    if (!numerify) continue block5;
                    res[i] = DIGITS[context.getRandomService().nextInt(10)];
                    continue block5;
                }
                case '\u00d8': {
                    if (!numerify) continue block5;
                    res[i] = DIGITS[context.getRandomService().nextInt(1, 9)];
                    continue block5;
                }
                case '?': {
                    if (!letterify) continue block5;
                    res[i] = (char)(baseChar + context.getRandomService().nextInt(26));
                    continue block5;
                }
            }
        }
        return String.valueOf(res);
    }

    public String regexify(String regex, FakerContext context) {
        RgxGen rgxGen = this.expression2generex.computeIfAbsent(regex, __ -> RgxGen.parse(regex));
        return rgxGen.generate(context.getRandomService().getRandomInternal());
    }

    public String examplify(String example, FakerContext context) {
        if (example == null) {
            return null;
        }
        char[] chars = example.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLetter(chars[i])) {
                chars[i] = this.letterify("?", context, Character.isUpperCase(chars[i])).charAt(0);
                continue;
            }
            if (!Character.isDigit(chars[i])) continue;
            chars[i] = DIGITS[context.getRandomService().nextInt(10)];
        }
        return String.valueOf(chars);
    }

    public String letterify(String letterString, FakerContext context) {
        return this.letterify(letterString, context, false);
    }

    public String letterify(String letterString, FakerContext context, boolean isUpper) {
        return this.bothify(letterString, context, isUpper, false, true);
    }

    public String templatify(String letterString, char char2replace, FakerContext context, String ... options) {
        return this.templatify(letterString, Map.of(Character.valueOf(char2replace), options), context);
    }

    public String templatify(String letterString, Map<Character, String[]> optionsMap, FakerContext context) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < letterString.length(); ++i) {
            char key = letterString.charAt(i);
            if (optionsMap.containsKey(Character.valueOf(key))) {
                String[] options = optionsMap.get(Character.valueOf(key));
                Objects.requireNonNull(options, "Array with available options should be non null");
                sb.append(options[context.getRandomService().nextInt(options.length)]);
                continue;
            }
            sb.append(key);
        }
        return sb.toString();
    }

    public String resolve(String key, Object current, BaseFaker root, FakerContext context) {
        return this.resolve(key, current, root, () -> key + " resulted in null expression", context);
    }

    public String resolve(String key, AbstractProvider<?> provider, FakerContext context) {
        return this.resolve(key, provider, provider.getFaker(), () -> key + " resulted in null expression", context);
    }

    public String resolve(String key, Object current, ProviderRegistration root, Supplier<String> exceptionMessage, FakerContext context) {
        String expression = root == null ? this.key2Expression.computeIfAbsent(context.getSingletonLocale(), __ -> MAP_STRING_STRING_SUPPLIER.get()).computeIfAbsent(key, __ -> this.safeFetch(key, context, null)) : this.safeFetch(key, context, null);
        if (expression == null) {
            throw new RuntimeException(exceptionMessage.get());
        }
        return this.resolveExpression(expression, current, root, context);
    }

    public String expression(String expression, BaseFaker faker, FakerContext context) {
        return this.resolveExpression(expression, null, faker, context);
    }

    public String fileExpression(Path path, BaseFaker faker, FakerContext context) {
        try {
            return Files.readAllLines(path).stream().map(t -> this.expression((String)t, faker, context)).collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read \"%s\"".formatted(path), e);
        }
    }

    public String csv(int limit, String ... columnExpressions) {
        return this.csv(";", '\"', true, limit, columnExpressions);
    }

    public String csv(String delimiter, char quote, boolean withHeader, int limit, String ... columnExpressions) {
        if ((columnExpressions.length & 1) == 1) {
            throw new IllegalArgumentException("Total number of column names and column values should be even (received %s columns: %s)".formatted(columnExpressions.length, Arrays.toString(columnExpressions)));
        }
        Field[] fields = new Field[columnExpressions.length >> 1];
        for (int i = 0; i < columnExpressions.length; i += 2) {
            int index = i;
            fields[i >> 1] = Field.field(columnExpressions[index], () -> columnExpressions[index + 1]);
        }
        Schema schema = Schema.of(fields);
        return CsvTransformer.builder().separator(delimiter).quote(quote).header(withHeader).build().generate(schema, limit + 1);
    }

    public String json(String ... fieldExpressions) {
        if ((fieldExpressions.length & 1) == 1) {
            throw new IllegalArgumentException("Total number of field names and field values should be even (received %s fields: %s)".formatted(fieldExpressions.length, Arrays.toString(fieldExpressions)));
        }
        ArrayList fields = new ArrayList();
        for (int i = 0; i < fieldExpressions.length; i += 2) {
            int index = i;
            fields.add(Field.field(fieldExpressions[index], () -> fieldExpressions[index + 1]));
        }
        Schema schema = Schema.of(fields.toArray(new SimpleField[0]));
        return JSON_TRANSFORMER.generate(schema, 1);
    }

    public String jsona(String ... fieldExpressions) {
        if (fieldExpressions.length % 3 != 0) {
            throw new IllegalArgumentException("Total number of field names and field values should be dividable by 3 (received %s field expressions: %s)".formatted(fieldExpressions.length, Arrays.toString(fieldExpressions)));
        }
        ArrayList fields = new ArrayList();
        for (int i = 0; i < fieldExpressions.length; i += 3) {
            int index = i;
            if (fieldExpressions[i] != null && Integer.parseInt(fieldExpressions[index]) > 0) {
                Object[] objects = new Object[Integer.parseInt(fieldExpressions[index])];
                Arrays.fill(objects, fieldExpressions[index + 2]);
                fields.add(Field.field(fieldExpressions[index + 1], () -> objects));
                continue;
            }
            fields.add(Field.field(fieldExpressions[index + 1], () -> fieldExpressions[index + 2]));
        }
        Schema schema = Schema.of(fields.toArray(new SimpleField[0]));
        return JSON_TRANSFORMER.generate(schema, 1);
    }

    protected String resolveExpression(String expression, Object current, ProviderRegistration root, FakerContext context) {
        if (!expression.contains("}")) {
            return expression;
        }
        int expressionLength = expression.length();
        String[] expressions = this.splitExpressions(expression, expressionLength);
        StringBuilder result = new StringBuilder(expressions.length * expressionLength);
        for (int i = 0; i < expressions.length; ++i) {
            Object resolved;
            String expr = expressions[i];
            if ((i & 1) == 0) {
                if (expr.isEmpty()) continue;
                result.append(expr);
                continue;
            }
            RegExpContext regExpContext = new RegExpContext(expr, root, context);
            ValueResolver val = this.REGEXP2SUPPLIER_MAP.get(regExpContext);
            if (val != null) {
                resolved = val.resolve();
            } else {
                int j;
                int length = expr.length();
                for (j = 0; j < length && !Character.isWhitespace(expr.charAt(j)); ++j) {
                }
                String directive = expr.substring(0, j);
                while (j < length && Character.isWhitespace(expr.charAt(j))) {
                    ++j;
                }
                String arguments = j == length ? "" : expr.substring(j);
                String[] args = this.splitArguments(arguments);
                resolved = this.resExp(directive, args, current, root, context, regExpContext);
            }
            if (resolved == null) {
                throw new RuntimeException("Unable to resolve #{" + expr + "} directive for FakerContext " + String.valueOf(context) + ".");
            }
            result.append(this.resolveExpression(Objects.toString(resolved), current, root, context));
        }
        return result.toString();
    }

    private String[] splitArguments(String arguments) {
        int length;
        if (arguments == null || (length = arguments.length()) == 0) {
            return EMPTY_ARRAY;
        }
        return ARGS_2_SPLITTED_ARGS.computeIfAbsent(arguments, __ -> {
            ArrayList<String> result = new ArrayList<String>();
            int start = 0;
            boolean argsStarted = false;
            for (int i = 0; i < length; ++i) {
                if (argsStarted) {
                    int cnt = 0;
                    while (i < length && arguments.charAt(i) == '\'') {
                        ++cnt;
                        ++i;
                    }
                    if (!(cnt & true)) continue;
                    result.add(arguments.substring(start, i - 1).replace("''", "'"));
                    argsStarted = false;
                    continue;
                }
                if (arguments.charAt(i) != '\'') continue;
                argsStarted = true;
                start = i + 1;
            }
            return result.toArray(EMPTY_ARRAY);
        });
    }

    private String[] splitExpressions(String expression, int length) {
        return EXPRESSION_2_SPLITTED.computeIfAbsent(expression, __ -> {
            int cnt = 0;
            for (int i = 0; i < length; ++i) {
                if (expression.charAt(i) != '}') continue;
                ++cnt;
            }
            ArrayList<String> list = new ArrayList<String>((cnt << 1) + 1);
            boolean isExpression = false;
            int start = 0;
            int quoteCnt = 0;
            for (int i = 0; i < length; ++i) {
                char c = expression.charAt(i);
                if (isExpression) {
                    if (c == '}' && !(quoteCnt & true)) {
                        list.add(expression.substring(start, i));
                        start = i + 1;
                        isExpression = false;
                        continue;
                    }
                    if (c != '\'') continue;
                    ++quoteCnt;
                    continue;
                }
                if (i >= length - 2 || c != '#' || expression.charAt(i + 1) != '{') continue;
                list.add(expression.substring(start, i));
                isExpression = true;
                start = i + 2;
                ++i;
            }
            if (start < length) {
                list.add(expression.substring(start));
            }
            return list.toArray(EMPTY_ARRAY);
        });
    }

    private Object resExp(String directive, String[] args, Object current, ProviderRegistration root, FakerContext context, RegExpContext regExpContext) {
        Object res = this.resolveExpression(directive, args, current, root, context);
        LOG.fine(() -> "resExp(%s [%s]) current: %s, root: %s, context: %s, regExpContext: %s -> res: %s".formatted(directive, Arrays.toString(args), current, root, context, regExpContext, res));
        if (res instanceof CharSequence) {
            if (((CharSequence)res).isEmpty()) {
                this.REGEXP2SUPPLIER_MAP.put(regExpContext, EMPTY_STRING);
            }
            return res;
        }
        if (res instanceof List) {
            Iterator it = ((List)res).iterator();
            while (it.hasNext()) {
                Object valueResolver = it.next();
                if (!(valueResolver instanceof ValueResolver)) continue;
                ValueResolver resolver = (ValueResolver)valueResolver;
                Object value = resolver.resolve();
                if (value == null) {
                    it.remove();
                    continue;
                }
                this.REGEXP2SUPPLIER_MAP.put(regExpContext, resolver);
                return value;
            }
            return null;
        }
        return res;
    }

    private Object resolveExpression(String directive, String[] args, Object current, ProviderRegistration root, FakerContext context) {
        String simpleDirective;
        if (directive.isEmpty()) {
            return directive;
        }
        int dotIndex = this.getDotIndex(directive);
        ArrayList<ValueResolver> res = new ArrayList<ValueResolver>();
        if (args.length == 0) {
            if (dotIndex == -1) {
                Method method;
                if (current instanceof AbstractProvider && (method = BaseFaker.getMethod((AbstractProvider)current, directive)) != null) {
                    res.add(new MethodResolver(method, current, args));
                    return res;
                }
                res.add(this.resolveFromMethodOn(current, directive, args));
            }
            if (dotIndex > 0) {
                Method method;
                String providerClassName = directive.substring(0, dotIndex);
                String methodName = directive.substring(dotIndex + 1);
                Object ap = root.getProvider(providerClassName);
                Method method2 = method = ap == null ? null : ObjectMethods.getMethodByName(ap, methodName);
                if (method != null) {
                    res.add(new MethodResolver(method, ap, args));
                    return res;
                }
            }
        }
        String string = simpleDirective = dotIndex >= 0 || current == null ? directive : this.classNameToYamlName(current) + "." + directive;
        if (args.length == 0) {
            res.add(new SafeFetchResolver(simpleDirective, context));
        }
        if (dotIndex == -1 && root != null && (current == null || root.getClass() != current.getClass())) {
            res.add(this.resolveFromMethodOn(root, directive, args));
        }
        if (dotIndex >= 0) {
            res.add(this.resolveFakerObjectAndMethod(root, directive, dotIndex, args));
        }
        if (dotIndex >= 0) {
            String key = this.javaNameToYamlName(simpleDirective);
            res.add(new SafeFetchResolver(key, context));
        }
        return res;
    }

    private boolean isSlashDelimitedRegex(String expression) {
        return expression != null && expression.startsWith("/") && expression.endsWith("/");
    }

    private String trimRegexSlashes(String slashDelimitedRegex) {
        return slashDelimitedRegex.substring(1, slashDelimitedRegex.length() - 1);
    }

    private int getDotIndex(String directive) {
        return directive.indexOf(".");
    }

    private String classNameToYamlName(Object current) {
        return this.javaNameToYamlName(current.getClass().getSimpleName());
    }

    private String javaNameToYamlName(String expression) {
        return NAME_2_YAML.computeIfAbsent(expression, __ -> {
            int length = expression.length();
            boolean firstLetterUpperCase = length > 0 && Character.isUpperCase(expression.charAt(0));
            int cnt = firstLetterUpperCase ? 1 : 0;
            for (int i = 1; i < length; ++i) {
                if (!Character.isUpperCase(expression.charAt(i))) continue;
                ++cnt;
            }
            if (cnt == 0) {
                return expression;
            }
            char[] res = new char[length + (firstLetterUpperCase ? cnt - 1 : cnt)];
            int pos = 0;
            for (int i = 0; i < length; ++i) {
                char c = expression.charAt(i);
                if (cnt > 0) {
                    if (Character.isUpperCase(c)) {
                        if (pos > 0) {
                            res[pos++] = 95;
                        }
                        res[pos++] = Character.toLowerCase(c);
                        --cnt;
                        continue;
                    }
                    res[pos++] = c;
                    continue;
                }
                res[pos++] = c;
            }
            return new String(res);
        });
    }

    private ValueResolver resolveFromMethodOn(Object obj, String directive, String[] args) {
        if (obj == null) {
            return null;
        }
        MethodAndCoercedArgs accessor = this.retrieveMethodAccessor(obj, directive, args);
        return accessor == null ? NULL_VALUE : new MethodAndCoercedArgsResolver(accessor, obj);
    }

    private ValueResolver resolveFakerObjectAndMethod(ProviderRegistration faker, String key, int dotIndex, String[] args) {
        String[] classAndMethod = dotIndex == -1 ? new String[]{key} : new String[]{key.substring(0, dotIndex), dotIndex == key.length() - 1 ? "" : key.substring(dotIndex + 1)};
        try {
            String nestedMethodName;
            String fakerMethodName = this.removeUnderscoreChars(classAndMethod[0]);
            MethodAndCoercedArgs fakerAccessor = this.retrieveMethodAccessor(faker, fakerMethodName, EMPTY_ARRAY);
            if (fakerAccessor == null) {
                LOG.fine(() -> "Can't find top level faker object named " + fakerMethodName + ".");
                return null;
            }
            Object objectWithMethodToInvoke = fakerAccessor.invoke(faker);
            MethodAndCoercedArgs accessor = this.retrieveMethodAccessor(objectWithMethodToInvoke, nestedMethodName = this.removeUnderscoreChars(classAndMethod[1]), args);
            if (accessor == null) {
                return NULL_VALUE;
            }
            return new MethodAndCoercedArgsResolver(accessor, objectWithMethodToInvoke);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to resolve faker object and method for %s (dotIndex=%s, args=%s)".formatted(key, dotIndex, Arrays.toString(args)), e);
        }
    }

    private MethodAndCoercedArgs retrieveMethodAccessor(Object object, String methodName, String[] args) {
        Class<?> clazz = object.getClass();
        MethodAndCoercedArgs accessor = MAP_OF_METHOD_AND_COERCED_ARGS.computeIfAbsent(clazz, cl -> new CopyOnWriteMap(WeakHashMap::new)).computeIfAbsent(methodName, mn -> new CopyOnWriteMap(WeakHashMap::new)).computeIfAbsent(args, __ -> this.accessor(clazz, methodName, args));
        if (accessor == null) {
            LOG.fine(() -> "Can't find method on %s called %s.".formatted(object.getClass().getSimpleName(), methodName));
        }
        return accessor;
    }

    private MethodAndCoercedArgs accessor(Class<?> clazz, String accessorName, String[] args) {
        LOG.fine(() -> "Find accessor named %s on %s with args %s".formatted(accessorName, clazz.getSimpleName(), Arrays.toString(args)));
        String name = this.removeUnderscoreChars(accessorName);
        Map classMethodsMap = CLASS_2_METHODS_CACHE.computeIfAbsent(clazz, __ -> {
            Method[] classMethods = clazz.getMethods();
            HashMap<String, Collection> methodMap = classMethods.length == 0 ? Collections.emptyMap() : new HashMap<String, Collection>(classMethods.length);
            for (Method m : classMethods) {
                String key = m.getName().toLowerCase(Locale.ROOT);
                methodMap.computeIfAbsent(key, k -> new ArrayList()).add(m);
            }
            LOG.fine(() -> "Detected accessor named %s on %s, stored to cache: %s".formatted(accessorName, clazz.getSimpleName(), methodMap));
            return methodMap;
        });
        Collection methods = classMethodsMap.getOrDefault(name, Collections.emptyList());
        if (methods == null) {
            LOG.fine(() -> "Didn't accessor named %s on %s with args %s (methods=%s)".formatted(accessorName, clazz.getSimpleName(), Arrays.toString(args), null));
            return null;
        }
        LOG.fine(() -> "Found accessor named %s on %s in cache: %s".formatted(accessorName, clazz.getSimpleName(), methods));
        Method mostRestrictive = null;
        String[] coercedArgumentsForMostRestrictive = null;
        for (Method current : methods) {
            String[] coercedArguments;
            if (current.getParameterCount() != args.length && (current.getParameterCount() >= args.length || !current.isVarArgs()) || (coercedArguments = args.length == 0 ? EMPTY_ARRAY : this.coerceArguments(current, args)) == null || !FakeValuesService.rightIsMostRestrictive(mostRestrictive, current)) continue;
            mostRestrictive = current;
            coercedArgumentsForMostRestrictive = coercedArguments;
        }
        if (mostRestrictive != null) {
            return new MethodAndCoercedArgs(mostRestrictive, coercedArgumentsForMostRestrictive);
        }
        LOG.fine(() -> "Didn't accessor named %s on %s with args %s (methods=%s)".formatted(accessorName, clazz.getSimpleName(), Arrays.toString(args), methods));
        return null;
    }

    private static boolean rightIsMostRestrictive(Method method1, Method method2) {
        if (method1 == null && method2 == null) {
            throw new NullPointerException("Both methods are null");
        }
        if (method2 == null) {
            return false;
        }
        if (method1 == null) {
            return true;
        }
        Class<?>[] parameterTypes1 = method1.getParameterTypes();
        Class<?>[] parameterTypes2 = method2.getParameterTypes();
        for (int j = 0; j < parameterTypes1.length; ++j) {
            if (parameterTypes1[j] == parameterTypes2[j]) continue;
            if (parameterTypes1[j].isPrimitive() && !parameterTypes2[j].isPrimitive()) {
                return false;
            }
            if (!parameterTypes1[j].isPrimitive() && parameterTypes2[j].isPrimitive()) {
                return true;
            }
            if (parameterTypes1[j].isPrimitive()) {
                for (Class<?> primitive : PRIMITIVES) {
                    if (primitive == parameterTypes1[j]) {
                        return false;
                    }
                    if (primitive != parameterTypes2[j]) continue;
                    return true;
                }
            }
            if (!parameterTypes1[j].isAssignableFrom(parameterTypes2[j])) continue;
            return true;
        }
        return false;
    }

    private String removeUnderscoreChars(String string) {
        return REMOVED_UNDERSCORE.computeIfAbsent(string, __ -> {
            if (!string.contains("_")) {
                return string.toLowerCase(Locale.ROOT);
            }
            char[] res = string.toCharArray();
            int offset = 0;
            int length = 0;
            int strLen = string.length();
            for (int i = strLen - 1; i >= offset; --i) {
                while (i > offset && string.charAt(i - offset) == '_') {
                    ++offset;
                }
                res[i] = res[i - offset];
                if (res[i] == '_') continue;
                ++length;
            }
            return String.valueOf(res, strLen - length, length).toLowerCase(Locale.ROOT);
        });
    }

    private Object[] coerceArguments(Method accessor, String[] args) {
        Object[] coerced = new Object[accessor.getParameterCount()];
        Class<?>[] parameterTypes = accessor.getParameterTypes();
        for (int i = 0; i < accessor.getParameterCount(); ++i) {
            boolean isVarArg = i == accessor.getParameterCount() - 1 && accessor.isVarArgs();
            Class<?> toType0 = FakeValuesService.primitiveToWrapper(parameterTypes[i]);
            Class<?> toType = isVarArg ? toType0.getComponentType() : toType0;
            try {
                Object coercedArgument;
                if (toType.isEnum()) {
                    Method method = toType.getMethod("valueOf", String.class);
                    if (isVarArg) {
                        coercedArgument = Array.newInstance(toType, args.length - i);
                        for (j = i; j < args.length; ++j) {
                            String enumArg = args[j].substring(args[j].indexOf(".") + 1);
                            Array.set(coercedArgument, j - i, method.invoke(null, enumArg));
                        }
                    } else {
                        String enumArg = args[i].substring(args[i].indexOf(".") + 1);
                        coercedArgument = method.invoke(null, enumArg);
                    }
                } else if (isVarArg) {
                    ctor = CLASS_2_CONSTRUCTOR_CACHE.computeIfAbsent(toType, __ -> {
                        Constructor<?>[] constructors;
                        for (Constructor<?> c : constructors = toType.getConstructors()) {
                            if (c.getParameterCount() != 1 || c.getParameterTypes()[0] != String.class) continue;
                            return FakeValuesService.getConstructorWithString(toType);
                        }
                        return null;
                    });
                    if (ctor == null) {
                        return null;
                    }
                    coercedArgument = Array.newInstance(toType, args.length - i);
                    for (j = i; j < args.length; ++j) {
                        Array.set(coercedArgument, j - i, ctor.newInstance(args[j]));
                    }
                } else if (toType == Character.class) {
                    coercedArgument = args[i] == null ? (Comparable<Boolean>)null : (Comparable<Boolean>)Character.valueOf(args[i].charAt(0));
                } else if (Boolean.class == toType) {
                    coercedArgument = Boolean.valueOf(args[i]);
                } else if (Integer.class == toType) {
                    coercedArgument = Integer.valueOf(args[i]);
                } else if (Long.class == toType) {
                    coercedArgument = Long.valueOf(args[i]);
                } else if (Double.class == toType) {
                    coercedArgument = Double.valueOf(args[i]);
                } else if (Float.class == toType) {
                    coercedArgument = Float.valueOf(args[i]);
                } else if (Byte.class == toType) {
                    coercedArgument = Byte.valueOf(args[i]);
                } else if (Short.class == toType) {
                    coercedArgument = Short.valueOf(args[i]);
                } else if (CharSequence.class.isAssignableFrom(toType)) {
                    coercedArgument = args[i];
                } else if (BigDecimal.class.isAssignableFrom(toType)) {
                    coercedArgument = new BigDecimal(args[i]);
                } else if (BigInteger.class.isAssignableFrom(toType)) {
                    coercedArgument = new BigInteger(args[i]);
                } else {
                    ctor = FakeValuesService.getConstructorWithString(toType);
                    coercedArgument = ctor.newInstance(args[i]);
                }
                coerced[i] = coercedArgument;
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException | NoSuchMethodRuntimeException e) {
                Throwable cause = FakeValuesService.unwrap(e);
                Level level = cause instanceof IllegalArgumentException || cause instanceof NoSuchMethodException ? Level.FINE : Level.SEVERE;
                LOG.log(level, "Unable to coerce " + args[i] + " to " + toType.getSimpleName() + " via " + toType.getSimpleName() + "(String) constructor", e);
                return null;
            }
        }
        return coerced;
    }

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        if (cls != null && cls.isPrimitive()) {
            return PRIMITIVE_WRAPPER_MAP.get(cls);
        }
        return cls;
    }

    private static Throwable unwrap(Throwable e) {
        Throwable throwable;
        if (e instanceof InvocationTargetException) {
            InvocationTargetException reflection = (InvocationTargetException)e;
            throwable = FakeValuesService.unwrap(reflection.getTargetException());
        } else {
            throwable = e;
        }
        return throwable;
    }

    private static Constructor<?> getConstructorWithString(Class<?> toType) {
        try {
            return toType.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodRuntimeException(e);
        }
    }

    static {
        PRIMITIVE_WRAPPER_MAP.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_WRAPPER_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPER_MAP.put(Character.TYPE, Character.class);
        PRIMITIVE_WRAPPER_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_WRAPPER_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPER_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPER_MAP.put(Double.TYPE, Double.class);
        PRIMITIVE_WRAPPER_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_WRAPPER_MAP.put(Void.TYPE, Void.class);
        EMPTY_STRING = new ConstantResolver("");
        NULL_VALUE = new ConstantResolver(null);
    }

    private record RegExpContext(String exp, ProviderRegistration root, FakerContext context) {
    }

    private static interface ValueResolver {
        public Object resolve();
    }

    private record ConstantResolver(String value) implements ValueResolver
    {
        @Override
        public Object resolve() {
            return this.value;
        }
    }

    private record MethodResolver(Method method, Object current, Object[] args) implements ValueResolver
    {
        @Override
        public Object resolve() {
            try {
                return this.method.invoke(this.current, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to call method %s.%s() on %s (args: %s)".formatted(this.method.getDeclaringClass().getName(), this.method.getName(), this.current, Arrays.toString(this.args)), e);
            }
        }

        @Override
        public String toString() {
            return "%s[method=%s.%s(), current=%s, args=%s]".formatted(this.getClass().getSimpleName(), this.method.getDeclaringClass().getSimpleName(), this.method.getName(), this.current, Arrays.toString(this.args));
        }
    }

    private class SafeFetchResolver
    implements ValueResolver {
        private final String simpleDirective;
        private final FakerContext context;

        private SafeFetchResolver(String simpleDirective, FakerContext context) {
            this.simpleDirective = simpleDirective;
            this.context = context;
        }

        @Override
        public Object resolve() {
            return FakeValuesService.this.safeFetch(this.simpleDirective, this.context, null);
        }

        public String toString() {
            return "%s[simpleDirective=%s, context=%s]".formatted(this.getClass().getSimpleName(), this.simpleDirective, this.context);
        }
    }

    private record MethodAndCoercedArgs(Method method, Object[] coerced) {
        private MethodAndCoercedArgs {
            Objects.requireNonNull(method, "method cannot be null");
            Objects.requireNonNull(coerced, "coerced arguments cannot be null");
        }

        private Object invoke(Object on) throws InvocationTargetException, IllegalAccessException {
            return this.method.invoke(on, this.coerced);
        }

        @Override
        public String toString() {
            return "%s[method=%s.%s(), coerced=%s]".formatted(this.getClass().getSimpleName(), this.method.getDeclaringClass().getSimpleName(), this.method.getName(), Arrays.toString(this.coerced));
        }
    }

    private record MethodAndCoercedArgsResolver(MethodAndCoercedArgs accessor, Object obj) implements ValueResolver
    {
        @Override
        public Object resolve() {
            return MethodAndCoercedArgsResolver.invokeAndToString(this.accessor, this.obj);
        }

        private static Object invokeAndToString(MethodAndCoercedArgs accessor, Object objectWithMethodToInvoke) {
            try {
                return accessor.invoke(objectWithMethodToInvoke);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Failed to invoke %s on %s".formatted(accessor, objectWithMethodToInvoke), FakeValuesService.unwrap(e));
            }
        }
    }

    private static class NoSuchMethodRuntimeException
    extends RuntimeException {
        public NoSuchMethodRuntimeException(NoSuchMethodException cause) {
            super(cause);
        }
    }
}

