/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.service;

import java.util.Objects;
import java.util.Random;
import net.datafaker.service.Range;

public class RandomService {
    private static final char[] HEX_UP = "0123456789ABCDEF".toCharArray();
    private static final char[] HEX_LOWER = "0123456789abcdef".toCharArray();
    private static final Random SHARED_RANDOM = new Random();
    private final Random random;

    public RandomService() {
        this(SHARED_RANDOM);
    }

    public RandomService(Random random) {
        this.random = random != null ? random : SHARED_RANDOM;
    }

    public int nextInt() {
        return this.random.nextInt();
    }

    public int nextInt(int maxExclusive) {
        return this.random.nextInt(maxExclusive);
    }

    public Integer nextInt(int minInclusive, int maxInclusive) {
        if (minInclusive > maxInclusive) {
            throw new IllegalArgumentException("Min (%s) > Max (%s)".formatted(minInclusive, maxInclusive));
        }
        if (maxInclusive + 1 < 0) {
            return (int)this.nextLong(minInclusive, maxInclusive);
        }
        return this.random.nextInt(minInclusive, maxInclusive + 1);
    }

    public int nextInt(Range<Integer> range) {
        return (int)this.nextLong(range.cast(Integer::longValue));
    }

    public float nextFloat() {
        return this.random.nextFloat();
    }

    public long nextLong() {
        return this.random.nextLong();
    }

    public long nextLong(long maxExclusive) {
        if (maxExclusive <= 0L) {
            throw new IllegalArgumentException("bound must be positive: " + maxExclusive);
        }
        return this.nextLong(0L, maxExclusive);
    }

    public long nextLong(Range<Long> range) {
        return switch (range.from().end()) {
            default -> throw new IncompatibleClassChangeError();
            case Range.End.EXCLUSIVE -> {
                switch (range.to().end()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case EXCLUSIVE: {
                        yield this.random.nextLong(RandomService.plusOne(range.from().value()), range.to().value());
                    }
                    case INCLUSIVE: 
                }
                yield this.random.nextLong(RandomService.plusOne(range.from().value()), RandomService.plusOne(range.to().value()));
            }
            case Range.End.INCLUSIVE -> {
                switch (range.to().end()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case EXCLUSIVE: {
                        yield this.random.nextLong(range.from().value(), range.to().value());
                    }
                    case INCLUSIVE: 
                }
                yield this.random.nextLong(range.from().value(), RandomService.plusOne(range.to().value()));
            }
        };
    }

    private static long plusOne(long value) {
        return value == Long.MAX_VALUE ? value : value + 1L;
    }

    public long nextLong(long min, long max) {
        return min == max ? min : this.random.nextLong(min, max);
    }

    public double nextDouble() {
        return this.random.nextDouble();
    }

    public double nextDouble(double min, double max) {
        return min + this.nextDouble() * (max - min);
    }

    public boolean nextBoolean() {
        return this.random.nextBoolean();
    }

    public byte[] nextRandomBytes(int numberOfBytes) {
        byte[] randomBytes = new byte[numberOfBytes];
        this.random.nextBytes(randomBytes);
        return randomBytes;
    }

    public String hex() {
        return this.hex(8);
    }

    public String hex(int length) {
        return this.hex(length, true);
    }

    public String hex(int length, boolean upper) {
        if (length <= 0) {
            return "";
        }
        char[] hexArray = upper ? HEX_UP : HEX_LOWER;
        char[] hexChars = new char[length];
        byte[] randomBytes = this.nextRandomBytes(length);
        for (int i = 0; i < length; ++i) {
            hexChars[i] = hexArray[(char)randomBytes[i] % hexArray.length];
        }
        return new String(hexChars);
    }

    public Random getRandomInternal() {
        return this.random;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RandomService)) {
            return false;
        }
        RandomService that = (RandomService)o;
        return Objects.equals(this.random, that.random);
    }

    public int hashCode() {
        if (this.random == SHARED_RANDOM) {
            return 1;
        }
        return this.random != null ? this.random.hashCode() : 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + String.valueOf(this.random);
    }
}

