/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v3.snappy;

import io.airlift.compress.v3.snappy.SnappyCompressor;
import io.airlift.compress.v3.snappy.SnappyNative;
import java.lang.foreign.MemorySegment;

public final class SnappyNativeCompressor
implements SnappyCompressor {
    private final SnappyNative snappyNative = new SnappyNative();

    public SnappyNativeCompressor() {
        SnappyNative.verifyEnabled();
    }

    public static boolean isEnabled() {
        return SnappyNative.isEnabled();
    }

    @Override
    public int maxCompressedLength(int uncompressedSize) {
        return Math.toIntExact(SnappyNative.maxCompressedLength(uncompressedSize));
    }

    @Override
    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        MemorySegment inputSegment = MemorySegment.ofArray(input).asSlice((long)inputOffset, inputLength);
        MemorySegment outputSegment = MemorySegment.ofArray(output).asSlice((long)outputOffset, maxOutputLength);
        return this.compress(inputSegment, outputSegment);
    }

    @Override
    public int compress(MemorySegment input, MemorySegment output) {
        return Math.toIntExact(this.snappyNative.compress(input, input.byteSize(), output, output.byteSize()));
    }
}

