/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;

public class PlanNodeStatsAndCostSummary {
    private final double outputRowCount;
    private final double outputSizeInBytes;
    private final double cpuCost;
    private final double memoryCost;
    private final double networkCost;

    @JsonCreator
    public PlanNodeStatsAndCostSummary(@JsonProperty(value="outputRowCount") double outputRowCount, @JsonProperty(value="outputSizeInBytes") double outputSizeInBytes, @JsonProperty(value="cpuCost") double cpuCost, @JsonProperty(value="memoryCost") double memoryCost, @JsonProperty(value="networkCost") double networkCost) {
        Preconditions.checkArgument((Double.isNaN(outputRowCount) || outputRowCount >= 0.0 ? 1 : 0) != 0, (String)"outputRowCount cannot be negative: %s", (Object)outputRowCount);
        Preconditions.checkArgument((Double.isNaN(outputSizeInBytes) || outputSizeInBytes >= 0.0 ? 1 : 0) != 0, (String)"outputSizeInBytes cannot be negative: %s", (Object)outputSizeInBytes);
        Preconditions.checkArgument((Double.isNaN(cpuCost) || cpuCost >= 0.0 ? 1 : 0) != 0, (String)"cpuCost cannot be negative: %s", (Object)cpuCost);
        Preconditions.checkArgument((Double.isNaN(memoryCost) || memoryCost >= 0.0 ? 1 : 0) != 0, (String)"memoryCost cannot be negative: %s", (Object)memoryCost);
        Preconditions.checkArgument((Double.isNaN(networkCost) || networkCost >= 0.0 ? 1 : 0) != 0, (String)"networkCost cannot be negative: %s", (Object)networkCost);
        this.outputRowCount = outputRowCount;
        this.outputSizeInBytes = outputSizeInBytes;
        this.cpuCost = cpuCost;
        this.memoryCost = memoryCost;
        this.networkCost = networkCost;
    }

    @JsonProperty(value="outputRowCount")
    public double getOutputRowCount() {
        return this.outputRowCount;
    }

    @JsonProperty(value="outputSizeInBytes")
    public double getOutputSizeInBytes() {
        return this.outputSizeInBytes;
    }

    @JsonProperty(value="cpuCost")
    public double getCpuCost() {
        return this.cpuCost;
    }

    @JsonProperty(value="memoryCost")
    public double getMemoryCost() {
        return this.memoryCost;
    }

    @JsonProperty(value="networkCost")
    public double getNetworkCost() {
        return this.networkCost;
    }
}

