/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.primitives.Shorts;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.json.ir.JsonLiteralConversionException;
import io.trino.json.ir.TypedValue;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;

public final class SqlJsonLiteralConverter {
    private SqlJsonLiteralConverter() {
    }

    public static Optional<TypedValue> getTypedValue(JsonNode jsonNode) {
        if (jsonNode.getNodeType() == JsonNodeType.BOOLEAN) {
            return Optional.of(new TypedValue((Type)BooleanType.BOOLEAN, jsonNode.booleanValue()));
        }
        if (jsonNode.getNodeType() == JsonNodeType.STRING) {
            return Optional.of(new TypedValue((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)jsonNode.textValue())));
        }
        return SqlJsonLiteralConverter.getNumericTypedValue(jsonNode);
    }

    public static Optional<TypedValue> getTextTypedValue(JsonNode jsonNode) {
        if (jsonNode.getNodeType() == JsonNodeType.STRING) {
            return Optional.of(new TypedValue((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)jsonNode.textValue())));
        }
        return Optional.empty();
    }

    public static Optional<TypedValue> getNumericTypedValue(JsonNode jsonNode) {
        if (jsonNode.getNodeType() == JsonNodeType.NUMBER) {
            JsonNode jsonNode2 = jsonNode;
            Objects.requireNonNull(jsonNode2);
            JsonNode jsonNode3 = jsonNode2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BigIntegerNode.class, DecimalNode.class, DoubleNode.class, FloatNode.class, IntNode.class, LongNode.class, ShortNode.class}, (JsonNode)jsonNode3, n)) {
                case 0 -> {
                    if (jsonNode.canConvertToInt()) {
                        yield Optional.of(new TypedValue((Type)IntegerType.INTEGER, jsonNode.longValue()));
                    }
                    if (jsonNode.canConvertToLong()) {
                        yield Optional.of(new TypedValue((Type)BigintType.BIGINT, jsonNode.longValue()));
                    }
                    throw new JsonLiteralConversionException(jsonNode, "value too big");
                }
                case 1 -> {
                    BigDecimal jsonDecimal = jsonNode.decimalValue();
                    int precision = jsonDecimal.precision();
                    if (precision > 38) {
                        throw new JsonLiteralConversionException(jsonNode, "precision too big");
                    }
                    int scale = jsonDecimal.scale();
                    DecimalType decimalType = DecimalType.createDecimalType((int)precision, (int)scale);
                    Object value = decimalType.isShort() ? Long.valueOf(Decimals.encodeShortScaledValue((BigDecimal)jsonDecimal, (int)scale)) : Decimals.encodeScaledValue((BigDecimal)jsonDecimal, (int)scale);
                    yield Optional.of(TypedValue.fromValueAsObject((Type)decimalType, value));
                }
                case 2 -> Optional.of(new TypedValue((Type)DoubleType.DOUBLE, jsonNode.doubleValue()));
                case 3 -> Optional.of(new TypedValue((Type)RealType.REAL, Float.floatToRawIntBits(jsonNode.floatValue())));
                case 4 -> Optional.of(new TypedValue((Type)IntegerType.INTEGER, jsonNode.longValue()));
                case 5 -> Optional.of(new TypedValue((Type)BigintType.BIGINT, jsonNode.longValue()));
                case 6 -> Optional.of(new TypedValue((Type)SmallintType.SMALLINT, jsonNode.longValue()));
                default -> Optional.empty();
            };
        }
        return Optional.empty();
    }

    public static Optional<JsonNode> getJsonNode(TypedValue typedValue) {
        Type type = typedValue.getType();
        if (type.equals((Object)BooleanType.BOOLEAN)) {
            return Optional.of(BooleanNode.valueOf((boolean)typedValue.getBooleanValue()));
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return Optional.of(TextNode.valueOf((String)Chars.padSpaces((Slice)((Slice)typedValue.getObjectValue()), (CharType)charType).toStringUtf8()));
        }
        if (type instanceof VarcharType) {
            return Optional.of(TextNode.valueOf((String)((Slice)typedValue.getObjectValue()).toStringUtf8()));
        }
        if (type.equals((Object)BigintType.BIGINT)) {
            return Optional.of(LongNode.valueOf((long)typedValue.getLongValue()));
        }
        if (type.equals((Object)IntegerType.INTEGER)) {
            return Optional.of(IntNode.valueOf((int)Math.toIntExact(typedValue.getLongValue())));
        }
        if (type.equals((Object)SmallintType.SMALLINT)) {
            return Optional.of(ShortNode.valueOf((short)Shorts.checkedCast((long)typedValue.getLongValue())));
        }
        if (type.equals((Object)TinyintType.TINYINT)) {
            return Optional.of(ShortNode.valueOf((short)Shorts.checkedCast((long)typedValue.getLongValue())));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            BigInteger unscaledValue = decimalType.isShort() ? BigInteger.valueOf(typedValue.getLongValue()) : ((Int128)typedValue.getObjectValue()).toBigInteger();
            return Optional.of(DecimalNode.valueOf((BigDecimal)new BigDecimal(unscaledValue, decimalType.getScale())));
        }
        if (type.equals((Object)DoubleType.DOUBLE)) {
            return Optional.of(DoubleNode.valueOf((double)typedValue.getDoubleValue()));
        }
        if (type.equals((Object)RealType.REAL)) {
            return Optional.of(FloatNode.valueOf((float)Float.intBitsToFloat(Math.toIntExact(typedValue.getLongValue()))));
        }
        return Optional.empty();
    }
}

