/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.inject.Inject;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.GroupByHashPageIndexer;
import io.trino.spi.Page;
import io.trino.spi.PageIndexer;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;

public class GroupByHashPageIndexerFactory
implements PageIndexerFactory {
    private final FlatHashStrategyCompiler hashStrategyCompiler;

    @Inject
    public GroupByHashPageIndexerFactory(FlatHashStrategyCompiler hashStrategyCompiler) {
        this.hashStrategyCompiler = Objects.requireNonNull(hashStrategyCompiler, "hashStrategyCompiler is null");
    }

    public PageIndexer createPageIndexer(List<Type> types) {
        if (types.isEmpty()) {
            return new NoHashPageIndexer();
        }
        return new GroupByHashPageIndexer(types, this.hashStrategyCompiler);
    }

    private static class NoHashPageIndexer
    implements PageIndexer {
        private NoHashPageIndexer() {
        }

        public int[] indexPage(Page page) {
            return new int[page.getPositionCount()];
        }

        public int getMaxIndex() {
            return 0;
        }
    }
}

