/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.arrayagg;

import io.trino.operator.aggregation.arrayagg.ArrayAggregationState;
import io.trino.operator.aggregation.arrayagg.GroupArrayAggregationState;
import io.trino.operator.aggregation.arrayagg.SingleArrayAggregationState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.Convention;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;

public class ArrayAggregationStateFactory
implements AccumulatorStateFactory<ArrayAggregationState> {
    private final Type type;
    private final MethodHandle readFlat;
    private final MethodHandle writeFlat;

    public ArrayAggregationStateFactory(@OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT}, result=InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER)) MethodHandle readFlat, @OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FLAT_RETURN)) MethodHandle writeFlat, @TypeParameter(value="T") Type type) {
        this.type = type;
        this.readFlat = readFlat;
        this.writeFlat = writeFlat;
    }

    public ArrayAggregationState createSingleState() {
        return new SingleArrayAggregationState(this.type, this.readFlat, this.writeFlat);
    }

    public ArrayAggregationState createGroupedState() {
        return new GroupArrayAggregationState(this.type, this.readFlat, this.writeFlat);
    }
}

