/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.airlift.slice.SizeOf;
import io.trino.array.BooleanBigArray;
import io.trino.array.LongBigArray;
import io.trino.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowState;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import jakarta.annotation.Nullable;

public class LongDecimalWithOverflowStateFactory
implements AccumulatorStateFactory<LongDecimalWithOverflowState> {
    public LongDecimalWithOverflowState createSingleState() {
        return new SingleLongDecimalWithOverflowState();
    }

    public LongDecimalWithOverflowState createGroupedState() {
        return new GroupedLongDecimalWithOverflowState();
    }

    public static class SingleLongDecimalWithOverflowState
    implements LongDecimalWithOverflowState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(SingleLongDecimalWithOverflowState.class);
        private static final int SIZE = (int)SizeOf.sizeOf((long[])new long[2]) + 1 + 8;
        private final long[] unscaledDecimal = new long[2];
        private boolean isNotNull;
        private long overflow;

        public SingleLongDecimalWithOverflowState() {
        }

        private SingleLongDecimalWithOverflowState(long[] unscaledDecimal, boolean isNotNull, long overflow) {
            System.arraycopy(unscaledDecimal, 0, this.unscaledDecimal, 0, 2);
            this.isNotNull = isNotNull;
            this.overflow = overflow;
        }

        @Override
        public boolean isNotNull() {
            return this.isNotNull;
        }

        @Override
        public void setNotNull() {
            this.isNotNull = true;
        }

        @Override
        public long[] getDecimalArray() {
            return this.unscaledDecimal;
        }

        @Override
        public int getDecimalArrayOffset() {
            return 0;
        }

        @Override
        public long getOverflow() {
            return this.overflow;
        }

        @Override
        public void setOverflow(long overflow) {
            this.overflow = overflow;
        }

        @Override
        public void addOverflow(long overflow) {
            this.overflow += overflow;
        }

        public long getEstimatedSize() {
            return INSTANCE_SIZE + SIZE;
        }

        public AccumulatorState copy() {
            return new SingleLongDecimalWithOverflowState(this.unscaledDecimal, this.isNotNull, this.overflow);
        }
    }

    public static class GroupedLongDecimalWithOverflowState
    extends AbstractGroupedAccumulatorState
    implements LongDecimalWithOverflowState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(GroupedLongDecimalWithOverflowState.class);
        private final BooleanBigArray isNotNull = new BooleanBigArray();
        private final LongBigArray unscaledDecimals = new LongBigArray();
        @Nullable
        private LongBigArray overflows;

        public void ensureCapacity(int size) {
            this.isNotNull.ensureCapacity((long)size);
            this.unscaledDecimals.ensureCapacity((long)size * 2L);
            if (this.overflows != null) {
                this.overflows.ensureCapacity((long)size);
            }
        }

        @Override
        public boolean isNotNull() {
            return this.isNotNull.get((long)this.getGroupId());
        }

        @Override
        public void setNotNull() {
            this.isNotNull.set((long)this.getGroupId(), true);
        }

        @Override
        public long[] getDecimalArray() {
            return this.unscaledDecimals.getSegment((long)this.getGroupId() * 2L);
        }

        @Override
        public int getDecimalArrayOffset() {
            return this.unscaledDecimals.getOffset((long)this.getGroupId() * 2L);
        }

        @Override
        public long getOverflow() {
            if (this.overflows == null) {
                return 0L;
            }
            return this.overflows.get((long)this.getGroupId());
        }

        @Override
        public void setOverflow(long overflow) {
            if (overflow == 0L && this.overflows == null) {
                return;
            }
            long groupId = this.getGroupId();
            if (this.overflows == null) {
                this.overflows = new LongBigArray();
                this.overflows.ensureCapacity(this.isNotNull.getCapacity());
            }
            this.overflows.set(groupId, overflow);
        }

        @Override
        public void addOverflow(long overflow) {
            if (overflow != 0L) {
                long groupId = this.getGroupId();
                if (this.overflows == null) {
                    this.overflows = new LongBigArray();
                    this.overflows.ensureCapacity(this.isNotNull.getCapacity());
                }
                this.overflows.add(groupId, overflow);
            }
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.isNotNull.sizeOf() + this.unscaledDecimals.sizeOf() + (this.overflows == null ? 0L : this.overflows.sizeOf());
        }
    }
}

