/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.BlockSet;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;

@ScalarFunction(value="array_except")
@Description(value="Returns an array of elements that are in the first array but not the second, without duplicates.")
public final class ArrayExceptFunction {
    private ArrayExceptFunction() {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block except(@TypeParameter(value="E") Type type, @OperatorDependency(operator=OperatorType.IDENTICAL, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionIsIdentical identicalOperator, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionHashCode elementHashCode, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int leftPositionCount = leftArray.getPositionCount();
        int rightPositionCount = rightArray.getPositionCount();
        if (leftPositionCount == 0 || rightPositionCount == 0) {
            return leftArray;
        }
        BlockSet set = new BlockSet(type, identicalOperator, elementHashCode, rightPositionCount + leftPositionCount);
        for (int i = 0; i < rightPositionCount; ++i) {
            set.add(rightArray, i);
        }
        BlockBuilder distinctElementBlockBuilder = type.createBlockBuilder(null, leftPositionCount);
        for (int i = 0; i < leftPositionCount; ++i) {
            if (!set.add(leftArray, i)) continue;
            type.appendTo(leftArray, i, distinctElementBlockBuilder);
        }
        return distinctElementBlockBuilder.build();
    }
}

